DROP TABLE IF EXISTS `sekolah`;

CREATE TABLE IF NOT EXISTS `sekolah` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `alamat` varchar(150) NOT NULL,
  `kota` varchar(20) NOT NULL,
  `jenjang` varchar(4) NOT NULL,
  `nama_kuitansi` varchar(25) NOT NULL,
  `info_kuitansi` varchar(10) NOT NULL,
  `info_tahap` varchar(10) NOT NULL,
  `info_kettrans` varchar(20) NOT NULL,
  `bg` varchar(10) NOT NULL,
  `menu` varchar(5) NOT NULL,
  `versi` varchar(10) NOT NULL,
  `bg_color` varchar(20) NOT NULL,
  `nama_pimpinan` varchar(100) NOT NULL,
  `pimpinan` varchar(50) NOT NULL,
  `model_kw` varchar(20) NOT NULL,
  `startPeriode` varchar(20) NOT NULL,
  `tgl_backup` date NOT NULL,
  `kops1` text NOT NULL,
  `kops2` text NOT NULL,
  `simakom_bendahara_nama` varchar(250) NOT NULL,
  `simakom_bendahara_nip` varchar(18) NOT NULL,
  `simakom_atasan_nama` varchar(250) NOT NULL,
  `simakom_atasan_nip` varchar(118) NOT NULL,
  `simakom_atasan_jabatan` varchar(250) NOT NULL,
  `simakom_atasan2_nama` varchar(250) NOT NULL,
  `simakom_atasan2_jabatan` varchar(250) NOT NULL,
  `simakom_ppk_nama` varchar(200) NOT NULL,
  `simakom_ppk_nip` varchar(18) NOT NULL,
  `simakom_ppk_jabatan` varchar(200) NOT NULL,
  `notice` text DEFAULT NULL,
  `notice2` text DEFAULT NULL,
  `tk` text DEFAULT NULL,
  `tp` varchar(10) NOT NULL,
  `webaddress` text NOT NULL,
  `aksesteller` varchar(5) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `sekolah` (`no`, `sekolah`, `alamat`, `kota`, `jenjang`, `nama_kuitansi`, `info_kuitansi`, `info_tahap`, `info_kettrans`, `bg`, `menu`, `versi`, `bg_color`, `nama_pimpinan`, `pimpinan`, `model_kw`, `startPeriode`, `tgl_backup`, `kops1`, `kops2`, `simakom_bendahara_nama`, `simakom_bendahara_nip`, `simakom_atasan_nama`, `simakom_atasan_nip`, `simakom_atasan_jabatan`, `simakom_atasan2_nama`, `simakom_atasan2_jabatan`, `simakom_ppk_nama`, `simakom_ppk_nip`, `simakom_ppk_jabatan`, `notice`, `notice2`, `tk`, `tp`, `webaddress`, `aksesteller`, `id`) VALUES
	(1,'KBTK CENDEKIA PANATAGAMA','Jl. Otista No.296 Sukamelang - Subang','Subang','PAUD','Nama Siswa','no','no','ya','primary','','','primary','Nurhayati Natalita, S.Pd.SD, M.M','Kepala Sekolah','3','1','2024-12-09','','','Dinda Finahar','3213076302980001','Nurhayati Natalita, S.Pd.SD, M.M','3209076502820000','Kepala Sekolah','Dr. Rohmat Buchori, S.Pd.I, M.S.I.','Direktur','','','','Jika ada ketidaksesuaian data, dimohon untuk segera menginformasikan kepada admin dan Kami sangat berterimakasih jika Ayah/Bunda melakukan pembayaran tepat waktu ..','','TERIMA KASIH','2025/2026','http://aks.panatagama.sch.id/kbtk','no','8E73735D50169571C0680DDA603E6BC4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `serial`;

CREATE TABLE IF NOT EXISTS `serial` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `sekolah` varchar(200) NOT NULL,
  `seri` varchar(100) NOT NULL,
  `aktivasi` varchar(100) NOT NULL,
  `tanggal` date NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `serial` (`no`, `sekolah`, `seri`, `aktivasi`, `tanggal`, `id`) VALUES
	(1,'KBTK CENDEKIA PANATAGAMA','3AC046-991E7P-46CB90-E9D046-327729','99E9D0CBE776084D304E96726A549AD469FCA96A3EFB882ADC0','2024-12-09','8E73735D50169571C0680DDA603E6BC4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user`;

CREATE TABLE IF NOT EXISTS `user` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` varchar(20) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `email` varchar(120) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `level` varchar(20) NOT NULL,
  `status` varchar(10) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user` (`no`, `id_user`, `nama`, `kelamin`, `email`, `hp`, `username`, `password`, `level`, `status`, `id`) VALUES
	(11,'9J2mFH','Administrator','L','admin@gmail.com','0888888888','admin','e10adc3949ba59abbe56e057f20f883e','admin','Aktif','7b7bc2512ee1fedcd76bdc68926d4f7b'),
	(26,'d0f83653fdb01ed928a4','Dinda Finahar ','P','','','tabungan','c1b1f59dbfe51b882c8b0dd09c86c1ca','tabungan','Aktif','4a226e3c91fc53741d15d2c9798c8760'),
	(27,'606ef979469528e637f6','Dinda Finahar','P','','','bendahara','c9ccd7f3c1145515a9d3f7415d5bcbea','bendahara','Aktif','35e791491d8b19d53b9ccedfe47283fc'),
	(28,'4bc2be4245c022748235','Nurhayati Natalita, S.Pd.SD, M.M','L','','','kepala','870f669e4bbbfa8a6fde65549826d1c4','monitoring','Aktif','8d937d271ec9908208507a7919259390'),
	(29,'6088971c048fb45e4317','Dinda Finahar  ','P','','','teller','8482dfb1bca15b503101eb438f52deed','teller','Aktif','a3299992ae3fb4a7f2e11fb3a725435c'),
	(31,'f134ede43bbb5a900131','Dr. Rohmat Buchori,S.Pd.I,M.S.I.','L','','','Direktur','4fbfd324f5ffcdff5dbf6f019b02eca8','monitoring','Aktif','f134ede43bbb5a900131'),
	(32,'722df1dc467b0a06e210','H. Mokh. Jaenudin / Hj. Citra Dewi','L','','','Owner','72122ce96bfec66e2396d2e25225d70a','monitoring','Aktif','722df1dc467b0a06e210');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `user_siswa`;

CREATE TABLE IF NOT EXISTS `user_siswa` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(50) NOT NULL,
  `kelamin` varchar(1) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `email` varchar(150) NOT NULL,
  `id` text NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `nip_2` (`nis`),
  KEY `nip` (`nis`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `user_siswa` (`no`, `nis`, `nama`, `kelamin`, `username`, `password`, `hp`, `email`, `id`, `status`, `created_at`, `updated_at`, `created_by`) VALUES
	(1,'24.11.24.290','ALYA AZZAHRA ALFATHUNNISA','P','24.11.24.290','69e07a9b796a3d2bd974355538b1d5c0','0853 5109 3888','','bb9eaae43069e0704400','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(2,'24.11.24.291','ANINDYA HASNA ALSHAMIRA','P','24.11.24.291','41c9e31538d433e79f0906fbda5b7e2f','0811 1111 2298','','52d55bd8ae41c9ee63f6','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(3,'24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','24.11.24.292','2813a7ff657591891edf550113dd1d84','0813 2056 3214','','848d4077d12813ab5eb4','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(4,'24.11.24.293','ATHAYYA DZAKA AFANDHI KUSNANTO','L','24.11.24.293','0aee28288b7ca5a545b6a9bbc292a8e6','0821 3000 6224','','efa273cd330aee205755','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(5,'24.11.24.295','AZNI GHAIDA IRIAWANSYAH','P','24.11.24.295','d4dbb94c106acd20bda03210ad9962c2','0813 8818 9061','','bac51e44a4d4dbba3beb','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(6,'24.11.24.297','JONATHAN WILLIAM HENDRICK','L','24.11.24.297','4431949fc0397c007aa625c4c699ed8a','0821 1821 0876','','12c4b97a81443197222c','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(7,'24.11.24.298','KAISLAM ELVANO ','L','24.11.24.298','15658081a66a7fe2ea98f5fe74a4b7af','0822 1778 4503','','4511889c461565855554','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(8,'24.11.24.299','LAYLA JENAR','P','24.11.24.299','1bca11b3a1e5a2eb20fc7d639f9240eb','0811 246 869','','d9b17d0df41bca15fbb1','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(9,'24.11.24.300','MUHAMMAD ARFAN AZATA','L','24.11.24.300','ac0b40c787cc710e404ba8e8a76a6512','0815 1592 2054','','c095309eb6ac0b488988','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(10,'24.11.23.288','NAZRIL ALEXANDER MULYADI','L','24.11.23.288','e3ee739a60a79141d1e09cdc452e25d8','0811 1406 020','','dc6dd85ccee3ee785059','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(11,'24.11.24.301','SHAQILA NESYA AR-RASYID','P','24.11.24.301','cd2f30f1fcac768a13025edf5f183944','0821 1275 3205','','116d626b77cd2f3b44ea','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(12,'24.11.24.312','ZAHRA SHABIRA HAMDANI','P','24.11.24.312','af19fb42ddd7e8a8148633d6e0e03bed','0823 2047 2910','','69a9414e93af19fa8492','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(13,'24.11.24.302','ZARA ARRAWFA NAYANIKA','P','24.11.24.302','7cb9320b30cdb5311bd999d7f72b61d4','0853 1701 7157','','43a835778f7cb93b29cf','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(14,'24.11.24.313','DERREN THEO OLIVER','L','24.11.24.313','d3f4d41c82fd26b5d00b5b39614cde16','0896 7342 0313','','a0800a4eb4d3f4de20a4','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(15,'24.11.24.303','AGAM AHMAD AL RUBY','L','24.11.24.303','6f81e2aebcd1b0310bc2227896205593','0821 2771 0711','','50a109387f6f81e552cf','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(16,'24.11.24.294','AZIER PUTRA KRISTOVANA','L','24.11.24.294','1b3082b7a9a3f101b690c837d1f9b531','0878 7979 0088','','062412e78f1b30821a92','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(17,'24.11.24.304','CHAIRA KHALIFANI YAHYA','P','24.11.24.304','e48f4289864aca5ca15e3bc1f3cc22a6','0813 2176 8985','','5ade1f82aae48f44b056','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(18,'24.11.24.305','DIRA ALSAVA PUTRI','P','24.11.24.305','45ade2c1cbd5cd06bded5a521a7a9418','0821 2713 0223','','26070c81ea45adea0cec','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(19,'24.11.24.306','ELFATHAN MAULANA AR-RASYID','L','24.11.24.306','6a98fc0c532b527a73643d8eb1ebedad','0878 3619 3009','','5f5205e3096a98fb4374','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(20,'24.11.24.307','KALANDRA ABRISAM IBRAHIM','L','24.11.24.307','43be73362b45453525c8676477aa150f','0821 2172 9844','','fa07e4a00343be735746','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(21,'24.11.23.274','LUQMAN AL RASYID','L','24.11.23.274','4831e7d4bedeb266631df5ec969aed1a','0821 4165 2434','','c08cbf80134831e053ff','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(22,'24.11.24.309','NAUREEN QIANA HASIBUAN','P','24.11.24.309','dda02284ae68f9a1d1f4c829171c44e9','0812 2154 6919','','1ae0830bb6dda02d57b1','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(23,'24.11.24.310','SHAFA AZIZIYAH RIZKY','P','24.11.24.310','eac46c083d566b82b3043ffd5d46b589','0823 2025 1661','','0ab8a39acaeac46033ef','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(24,'24.11.23.276','SYAHNAZ MAFAZA ADLILLAH POHAN','P','24.11.23.276','8e6dbb4a7e91f52b648e847b51a94a70','0812 2392 1864','','43c4f707718e6db06eff','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(25,'24.11.23.277','VELICA KIERAN SLAMET GHUMAISHA','P','24.11.23.277','072bff9a9416f49f9b59664cb95557f5','0811  2261  67','','a47571e915072bfe57b9','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(26,'24.11.24.311','WANGSA DINATA','L','24.11.24.311','e68f12c3e5f54e883aa0fc7f5cee0554','0895 0168 9039','','64bf94d896e68f10f5fc','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(27,'24.11.24.315','ZARA NADIRA','P','24.11.24.315','1f85b74b53d1a94e495d2163d91299fe','0812 7411 7865','','eabdcf40bb1f85b76a63','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(28,'24.11.24.314','FARSYA UCHENNA CENDEKIA ALFAZA','P','24.11.24.314','7448f25d8d441548b770a782c7f58dcd','0812 8284 8881','','00bfee15857448f5dc45','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(29,'24.22.24.304','AFIYA NASYITA MUNANDAR','P','24.22.24.304','44ebd3b5860d9c8f5cd6a70f18ca98c9','0812 8297 3667','','eb1fa4658d44ebd7714a','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(30,'24.22.24.305','ALDEBARAN MIQDAD DAMARA','L','24.22.24.305','3d95a048146e7852a910dac9d2517514','0821 1387 5831','','5c9e2086ed3d95ab58c2','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(31,'24.22.24.306','HAFY RASYID ADSKHAN','L','24.22.24.306','55c446145f338215e17bf8bf629f311e','085216330370','','d02622c2bf55c44ce497','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(32,'24.22.24.307','HASYA KHALISHA LASHIRA','P','24.22.24.307','72a7ba9617d0d9f67082b29d83519d71','0822 2199 9876','','e136df6e7d72a7b5ab6f','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(33,'24.22.24.308','MAYA SYIFA NUR&#039;AINI','P','24.22.24.308','6f9b1c22eb056a52ae5cbe389d75eca7','0838 6161 5273','','ca6bec81966f9b1b30d7','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(34,'24.22.24.309','MECCA ARETHA RAHMAN ','P','24.22.24.309','d973dcd03f9ba2502967a81f5a6a7b89','0878 2551 5169','','786b1aa3bed973da820a','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(35,'24.22.24.310','MUHAMMAD AVICENNA IRIAWANSYAH','L','24.22.24.310','37cad80a1ba62077bfa1de6bf976ea43','0813 8818 9061','','aa1a22216937cada0b08','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(36,'24.22.24.311','RADEA WIRASENA ARSY','L','24.22.24.311','2b41968417f7c2d6c176e432b72fb6a0','0852 2220 0157','','88b3a7b2172b4198cf48','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(37,'24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','24.22.24.312','556f9b0394926b07496e1d141659c96d','0813 2056 3214','','fb74028fd6556f91b66e','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(38,'24.22.24.313','RYUGA DANEER ERLEN','L','24.22.24.313','1e07b928d230291bdfa595c2fb2c7a71','0813 2045 4546','','89068cf31c1e07b36785','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(39,'24.22.24.314','SAIFAN MULTAZZAM SAIFULLOH','L','24.22.24.314','230c18776dc361e63f0aa7a37baf1f52','081353219771','','3e81f09182230c1d38f2','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(40,'24.22.24.315','SENANDUNG HUSNA GANTARI SETIAWAN','P','24.22.24.315','81916fc7a3d626b7fc9f085fcc07cc3f','0856 2064 634','','e673a96b4881916e0a81','Aktif','2024-12-24 23:12:24','2024-12-24 23:12:24','50463efa59739fd6caf07114793ee291'),
	(41,'24.22.24.316','SHAE ZAHSY HANANIA','P','24.22.24.316','e6b1f00b53f18bfda7ce776876ff8720','0821 1199 7789','','362f05b66ae6b1f875d5','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(42,'24.22.24.317','TANISHA INDANA SAKHI','P','24.22.24.317','4be4b9e0890f468a620146293cb3fc20','0822 1884 7778','','fbf4441f914be4bf98d5','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(43,'24.22.24.341','NAWRA SYAFA ASHADIYA','P','24.22.24.341','82a015b18c44f3a6ac070653047d2490','0852 6368 2999','','e8651f22c782a01d0289','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(44,'24.22.24.343','NAJWA AULIYA AHMAD','P','24.22.24.343','598c2abd84c26d6d2215c37babbf0a66','0821 3096 3291','','732c76bc2f598c278d2d','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(45,'24.22.24.318','ABYAZ ZAYN KUSUMA','L','24.22.24.318','29f786a7a73ed999cfffa23201dc1107','0821 3065 3644','','c375bafadc29f783e720','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(46,'24.22.24.319','AISHA RAIHANA HERYANTO','P','24.22.24.319','fc273bb6adc781c7e0e1764a9dc53030','0853 1693 3321','','bfa0bb8376fc273fd869','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(47,'24.22.24.320','ALESHA APRILIA ZABIR','P','24.22.24.320','99d9cd7265809c2ee9e3c6122bc05346','0822 1408 7842','','470acaabd199d9cd8daa','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(48,'24.22.24.321','DINDA MARYAM NURGHAISANI','P','24.22.24.321','8c852d8346569885666ab5a545cb945a','0859 5635 2607','','bcd53e16688c85215ee5','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(49,'24.22.24.322','ELZAIDAN RAID ALHABSYI','L','24.22.24.322','10541fd445af6f1217d06175a763818e','0821 1524 1722','','7d641d54dc10541c4c60','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(50,'24.22.24.323','ELZIO ABYAN BIMO PUTRA','L','24.22.24.323','062ed081c5d41d6b480278d80a223d37','0877 1997 4365','','07948034ee062ed67f9f','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(51,'24.22.24.324','HAFIZH ALFAREZI OKTAPIAN','L','24.22.24.324','08bf954253717999e41064d0c267cfc8','0896 8748 7520','','b76093d2fc08bf90381a','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(52,'24.22.24.325','I GUSTI AGUNG ALETA ZELINE ARTA','P','24.22.24.325','eb7d7cf5fb66bf316f556b2db1cc06d6','0811 2007 013','','79da2f1a10eb7d7927aa','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(53,'24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','24.22.24.326','9de8568c53f15202e8046871f890ec9b','0811 2290 168','','67a2efeef09de85fc0d0','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(54,'24.22.24.327','MUHAMMAD KENZIE RAFISQY','L','24.22.24.327','565496ccd56dfd3a2f8dae18a35bfa77','0823 1694 4443','','c58e12bab55654994438','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(55,'24.22.24.328','QIANA AJENG CAHYANI','P','24.22.24.328','2e053cc5dcd64e7af9f020d3fa10d056','0853 2157 5978','','492e20bae32e053276ad','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(56,'24.22.24.329','RADELLA AZALIA ARSY','P','24.22.24.329','4bd0249d249182a8a158ede3f6852ba8','0895 3929 71009','','46cc7a356c4bd025d62b','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(57,'24.22.24.330','RAZQA ZHAFRAN HAMDANI','L','24.22.24.330','9c93788688cba7b8cd56158b7c358470','0823 2047 2910','','a537094f629c9378005a','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(58,'24.22.24.340','BRIEZATTA SHANAYA ARGENTHA','P','24.22.24.340','1504444d07fefb79bb195dcccd9d41fa','0857 5979 3210','','bad14c5fb21504425807','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(59,'24.22.24.342','JESSICA RADYA ARABELLA','P','24.22.24.342','26818206dc30caf650f0b9ea5f973ab0','0896 7342 0313','','6153079f4226818fc544','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(60,'24.22.23.285','ABYAN REYNAND DILLAH','L','24.22.23.285','0e4da1e65ca419008786358747be63b9','0812 5027 5681','','432cfb981f0e4daad9a0','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(61,'24.22.23.288','ADZKIYA AFSHEEN NOVIANTIKA','P','24.22.23.288','d5d2877322a9036cd60390cfc93eb268','0895 3886 18037','','a3e3287a9ed5d28e20f3','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(62,'24.22.23.287','ALFARIZI IBNI OKTARIAN','L','24.22.23.287','5bc852d52b62734131e2fe46f7c73aeb','0896 6555 2009','','3fe1ecb4dc5bc854d755','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(63,'24.22.23.294','ARKHA SAPUTRA','L','24.22.23.294','00a766cedbb5714871a1168865450c2a','0823 1553 1721','','4756d0103f00a7643617','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(64,'24.22.24.331','ASHIMA KEYNARA LEKSY','P','24.22.24.331','3acf48038a6e6f500b1226a08f28223a','0852 2223 8989','','c2d6300e9f3acf4b76f4','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(65,'24.22.24.332','AZ ZAHRAH CARISSA PUTRI FAUZI','P','24.22.24.332','6b0a21d44bbde104084858441cc851e4','0819 1833 8059','','c267ddc8e46b0a273436','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(66,'24.22.23.289','EL MAIZA AFLAHA NURHUDA','P','24.22.23.289','3023623fa996df980e6699f1dd523ebd','0812 2287 0202','','72a0be775e302361c2b9','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(67,'24.22.24.333','IBNU SAKTIAWAN SIHOTANG','L','24.22.24.333','342733156b8baa37c54498f618b5714c','0811  2111 039','','c8013f923934273f970a','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(68,'24.22.23.292','KENZI ZAIDAN FAEYZA','L','24.22.23.292','a3458283a2167997bde8a2c11d6b78fd','0857 1049 4610','','510a3a8cada345877f7c','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(69,'24.22.24.334','KHAIRA SENANDUNG MAHLIGA','P','24.22.24.334','e5faa7573fc63d1bf1de07187e994976','0821 1332 0762','','d7ecaecbdae5faa56a7f','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(70,'24.22.23.297','KHALIF SHAKEIL ATHAFARIZ SUSANTO','L','24.22.23.297','5a8792773177e61689dcf43afced4aee','081222023741','','f6463fdfe15a879c3adb','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(71,'24.22.23.293','MARITZA SYAFIRA DEWI','P','24.22.23.293','ff597d8f0239dcab13d68b2376497acf','0878 7979 0088','','22cb40e1f2ff597c4c66','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(72,'24.22.24.335','MOCH. DILIAN MARVINE ALGHANIY','L','24.22.24.335','f8b7560cb14fd17c8d4d408138a64124','0812 2254 3005','','4695d0a3b0f8b75a2b8b','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(73,'24.22.24.336','MOCH. NAZIRUL ASROPI S.','L','24.22.24.336','f5e5430bb9fd571792d92b8aad8be4b5','0823 21660872','','fc98a38183f5e54f63fc','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(74,'24.22.24.337','MUHAMMAD ALHAFIDZ MAULA','L','24.22.24.337','42cc5da3cdc824975f291f1110ff8019','0877 2681 2704','','14c235271142cc50982f','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(75,'24.22.24.338','MUHAMMAD ZAYN AL FATH','L','24.22.24.338','b5c576bfbc62b014580cc36bc5a77ee2','0812 2116 4662','','27adb5d76ab5c57d0698','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(76,'24.22.24.339','SAIF HAWARI','L','24.22.24.339','edb25609fb913819806afd4ac5fa4858','0895 3319 69649','','a411afda34edb2549a45','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(77,'24.22.23.283','SHAKIERRA AIWA MAUREEN','P','24.22.23.283','2c8c22b17def7087c6778b5eec8cf358','0822 4039 6666','','9287a1197a2c8c2931f6','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(78,'24.22.23.295','SHANUM VALERIAN ARDAFAIS','P','24.22.23.295','6bc4c3c15dc9f842db4314f119c2f098','0811 220 417','','1b52d020d86bc4c9c8c1','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(79,'24.22.23.282','TACIO DIKA KUSMAYADI','L','24.22.23.282','01846707572263ca57bc7e5e803b7248','0853 2158 8877','','8431bfeb40018469b5d8','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(80,'24.22.23.298','TAMHIDAN HADINATA','L','24.22.23.298','e7a5401a6f9ad0feb9254f2538f464b7','0821 3982 8180','','d6a9600487e7a54ad8c3','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291'),
	(81,'24.22.23.284','ZEVITA MYESHA RINALDY','P','24.22.23.284','9bbf26ca8b1f3ba9a547e721d3f7381e','0812 9410 0420','','7c4008f5539bbf2387df','Aktif','2024-12-24 23:12:25','2024-12-24 23:12:25','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_akun`;

CREATE TABLE IF NOT EXISTS `simakom_ref_akun` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `akun` varchar(6) NOT NULL,
  `akun_custome` varchar(50) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=310 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_akun` (`no`, `kategori`, `akun`, `akun_custome`, `uraian`, `id`) VALUES
	(17,'A','100103','100103','Penerimaan Biaya Pendaftaran Siswa Baru','9ae26ff44c264acdb03e7b55bce2cf4901a'),
	(18,'A','100201','100201','Penerimaan Biaya Extrakurikuler','7c7523f13ef609df9b1d9f82fed8bd1ce3c'),
	(13,'A','100000','100000','Penerimaan Saldo Kas Tahun Lalu','14ee22eaba297944f4f6fd9c6dbe2f2b555'),
	(14,'A','100101','100101','Penerimaan SPP','732e276ec85f14e5ddca80e9dd3badedebc'),
	(15,'A','100102','100102','Penerimaan Biaya Pendidikan','54ebda338d71682fb4f81166e8399d6a962'),
	(16,'A','100104','100104','Penerimaan Biaya Kelas KKO','72984ef85cbebaa1de90c11baa503343547'),
	(63,'B','200401','200401','Kegiatan Fristday Activity','9756342aa9434bec0b7a6a0b416684cb1b2'),
	(64,'B','200402','200402','Kegiatan Fieldtrip','800d427f7b19cf6a2806e2569846a0a74e3'),
	(230,'B','200403','200403','Kegiatan Lomba Kemerdekaan','de345b20a5d60ae6f7b9d6a99ba35c65cc2'),
	(53,'B','200101','200101','Penyusunan KOSP (KB &amp; TK)','fae1f94c506115eedc4bd60b07e96252347'),
	(54,'B','200102','200102','Penyusunan ATP dan Modul Ajar','bc0db1ef7e8b638101b96b3ac8ffb11693c'),
	(36,'A','100301','100301','Bantuan Operasional Sekolah (BOP)','a6061a0c10b13bfe1d984d77996e6037999'),
	(37,'A','199999','199999','Penerimaan Lain','174d10d8134ad94f0c285f19d5f8238d516'),
	(38,'A','100105','100105','Penerimaan Biaya Kelas Akademik','123faaaa42b5d906c7d0fa6b50781c14bca'),
	(55,'B','200103','200103','Penyusunan Program Kegiatan &amp; Eskul (RAKER)','bd0b3e43c34a47c21bd9c8243cd47f9d2ee'),
	(56,'B','200201','200201','Pelaksanaan Asesment','fafe0a5ad92e1f803ef374ad4e365a9f29a'),
	(57,'B','200202','200202','Penyusunan Rapot','452bfed404cb95d6e873e292175d80c0fe0'),
	(60,'B','200301','200301','Lomba Kedinasan','8aee09e623dfe2f494f36e0749b19be33fa'),
	(232,'B','200405','200405','Kegiatan Medical Check-up/Dental Check-up','eb9db715b0143999d0874994cb3643ed20a'),
	(231,'B','200404','200404','Kegiatan Aquatic','121a28c1fea353016a34280742f9dd4e751'),
	(50,'A','100002','100002','Penerimaan Pembayaran Piutang Tahun lalu','bb36c34eb6644abd00d2d4669de00b12fe4'),
	(51,'A','100001','100001','Penerimaan Saldo Bank Tahun Lalu','e2a6a1ace3526682325fbdf3406e4e795e5'),
	(52,'A','100401','100401','Sumbangan Wakaf Infaq dan Sodaqoh','b603648a5ab54a5ef1a2220ae5bcde23676'),
	(87,'B','200501','200501','Promosi Sekolah (Iklan Digital, Stand&quot;, event lomba, Trial Class)','269727a2b3422924546f63c49b3c642ba27'),
	(88,'B','200502','200502','Brosur, Spanduk, Map PPDB','e298165053c78f0d12afe0b11105907f219'),
	(89,'B','200503','200503','Kegiatan Home Visit (wawancara calon walisiswa)','c5a8081a0b50c26d200f5b4859cd7a915a1'),
	(90,'B','200504','200504','Panitia PPDB','2ba1245d06438827764321300b9b0586b9c'),
	(92,'B','200601','200601','Kertas lipat','fe685cb7c788f34a26eb8417bd067fe74e5'),
	(93,'B','200602','200602','Kertas karton','27982b006f030d710819594ff4bf6e87663'),
	(94,'B','200603','200603','Pensil','2bbb64f4948501ae70ab6dcd3d53a0dab27'),
	(95,'B','200604','200604','Spidol kecil untuk siswa','894ba5d3ca43f3b233614f3c2089d715f6b'),
	(96,'B','200605','200605','Ballpoint','57546c17be8d31d8a7eed3b418920de7d9a'),
	(97,'B','200606','200606','Spidol Whiteboard','9d43605d09ea3b9c4f38c5cfa5bfabc76b7'),
	(98,'B','200607','200607','Stempel','9fd36857f0a758955f9d10c7947497ffc75'),
	(99,'B','200608','200608','Tinta stampel','723ad4a76960672de63ce3188ea7f5d857f'),
	(100,'B','200609','200609','Bak Stempel','21d223e3b8353004d6478672725cd164ef1'),
	(101,'B','200610','200610','Penggaris','8c102a51c5ae62e630dd214f8e965be7d40'),
	(102,'B','200611','200611','Type x','99a541b1767705f56f0bb152f5cd7697adf'),
	(103,'B','200612','200612','Penghapus papan tulis','93295df6dd0f83e5eb7e6e6f57e758cc029'),
	(104,'B','200613','200613','Lem Uhu','28f5120653a8a33d6feb6060611443deddd'),
	(105,'B','200614','200614','Lem Fox','e484924ae85ed1a4a1db584f299298075ff'),
	(106,'B','200615','200615','Stapler','3d3c965b3e808292e0fac5ab13f7060a57e'),
	(107,'B','200616','200616','Isi stapler kecil, sedang, besar','63376d365d6ccaced5ed1b6c1e1664d8832'),
	(108,'B','200617','200617','Paper clip','8e20f33650fe757484e9348316e709486dc'),
	(109,'B','200618','200618','Binder clip','00a7955db8975a0c355bc0981ae78fa395c'),
	(110,'B','200619','200619','Stop map','a81e9040b2d45e89e03f7c2701779467a7b'),
	(111,'B','200620','200620','Sneilheckter','e6d73ff42ca37b8252b805b466f41fe9442'),
	(112,'B','200621','200621','Kertas jilid/cover','78d0db637a6be9527997794934927b3792d'),
	(113,'B','200622','200622','Plastik Jilid / kertas mika','74f43b97b107bc1828f4ea033c4afa256be'),
	(114,'B','200623','200623','Lakban bening kecil','91296996831f9d78a3bbbd75a3845b6f719'),
	(115,'B','200624','200624','Lakban bening besar','40922b7f18a8158a419f6faba0f45da07b8'),
	(116,'B','200625','200625','Lakban hitam','5ef9934e88e3b08d46d8902749beb7b65e4'),
	(117,'B','200626','200626','Lakban kertas','50e6ad5ec6ecdcaa71b4400ceed46d19941'),
	(118,'B','200627','200627','Doubletip','bb2df5082823f029c740b477eb8dbce11f1'),
	(119,'B','200628','200628','Double Foam','27b8bce892d9da55225a1d63e64778339fe'),
	(120,'B','200629','200629','Label stiker','78162b534e4669857e31a622c11ce1eb474'),
	(121,'B','200630','200630','Kertas kado','401e95d96df792327d2c9ec0a1fa213ee8b'),
	(122,'B','200631','200631','Kertas Kopi','a78d9c1d169f71c9343ee9844640b659fad'),
	(123,'B','200632','200632','Goody bag','193872f954d96db545a6ec4469d61b856c7'),
	(137,'B','200701','200701','Amplop Besar (Coklat)','cfe5a0b5a40b4ddf6b781bda513923030a7'),
	(271,'B','201803','201803','Bahan pembersih kamar mandi','219d99e1dc8e864e03342d1a2e8a44eeabd'),
	(272,'B','201804','201804','Pewangi ruangan','4fa5b50866aa837fd180ac5233c128b27dd'),
	(141,'B','200801','200801','Masker','0196d9752bc04c22f7d518d24c80bd8e92e'),
	(142,'B','200802','200802','Obat - Obatan UKS','3e731971ec06f2df7b532aaad8d6258922c'),
	(143,'B','200803','200803','P3K','99646e8670b2b36e67c335ebf25f7c7d3ba'),
	(273,'B','201805','201805','Sabun cuci tangan','41570d6978ceeface5671a63aa5374c94de'),
	(145,'B','200901','200901','Pengadaan alat olahraga','b37fac3f1acf6c4a107ce563063bd081952'),
	(146,'B','200902','200902','Pengadaan bahan praktik Mapel','d726518409653dd5b51f3214e7fe33fb9a1'),
	(150,'B','201001','201001','Snack Siswa','7205927daeeda6c45cf4d93041397c4b43e'),
	(151,'B','201002','201002','Makan Besar','6191d9a03f47c6175dee06076fac4477c62'),
	(152,'B','201003','201003','Minum','8c0c53a416d2e9366728c3c9e7c0d03247d'),
	(262,'B','201204','201204','Tunj Gaji Guru dan Pegawai dari Dana BOP','d01bb7551d54d9c13e489fb5e86f0ed1c4d'),
	(261,'B','201203','201203','Honor Guru dan Pegawai','9365f8127adaa9159f98ba5d7c4567979bc'),
	(260,'B','201202','201202','THR Guru dan Pegawai','7f522e54608e425efda384fc669ca0cd81d'),
	(156,'B','201101','201101','Kegiatan IGTKI','8620654f6ad3e802059822acd60fe54c0f7'),
	(157,'B','201102','201102','Kegiatan Gugus','2908e9c011c6ecb378cb23a7f86bc418b66'),
	(158,'B','201103','201103','Kegiatan Study Banding','89c3c88d08a9132703aa3421abc4641415b'),
	(159,'B','201201','201201','Perjalanan Dinas dan Humas','ca294205968d8efa2979ef7cade60cb9099'),
	(161,'B','201301','201301','Seragam Guru dan Karyawan','a561b35b5b7be09b3e019aa60d905094f73'),
	(162,'B','201302','201302','ATK Guru','64eca661bdf5c11ad14026f06b4584488b4'),
	(267,'B','201507','201507','Maintenance Komputer/Laptop','8e6ef528f76b8d0fdb5844f5eac271fe6aa'),
	(165,'B','201401','201401','Rapat wali murid awal , parenting','e3ad01979fd466193dce7fd2d4dee0b2a6f'),
	(166,'B','201402','201402','Rapat wali murid Akhir Tahun','9c0e545ec5666710441d3f04e9123664185'),
	(266,'B','201506','201506','Maintenance Printer','f04e428e7774db5c5bb06149013cc10cf3b'),
	(265,'B','201505','201505','Maintenance mobil dan motor operasional','2bdbe037abdf28af133dac79a4b9a9e8d5d'),
	(264,'B','201504','201504','Pulsa Operator TK','47cc47e8ca01ec7d6da36e1af968120bf6c'),
	(263,'B','201503','201503','Mintenance AC','30f28d4b9812dfc0c43c6d5f330512132fc'),
	(172,'B','201501','201501','Listrik','0b465072fdba233cddfb25c52a423dd3e47'),
	(173,'B','201502','201502','Wifi + Telepon','f27635bc9afbfa8df38f88b131eb31e9b45'),
	(175,'B','201601','201601','Handphone TK','13174a5ae720f55e2a47004c766cfc3ba41'),
	(176,'B','201602','201602','Neon Box','d8c5bb17b7dbe7499e8fd4a0eca1004c7f7'),
	(178,'B','201701','201701','Burung Garuda dan photo presiden dan wakil','a66fad44699270d57891c7be048da27913e'),
	(179,'B','201702','201702','Hiasan kelas','a5fad663865a88a3aafba7d0ea4fc01e90a'),
	(180,'B','201703','201703','Alat kebersihan','6e48cba0ec9358d3aa971c20629f7a94337'),
	(278,'B','201810','201810','Sapu','c6ab182968072aa6a614f954363becf756c'),
	(277,'B','201809','201809','Gayung','354a176d8b5a41d574ea7613f48eb30e556'),
	(276,'B','201808','201808','Ember','33a0fbf4efb2a6eb14624bcdf327d65d191'),
	(275,'B','201807','201807','Plastik sampah','29733bb83f4d6df810352b3c1572fbe3eff'),
	(274,'B','201806','201806','Serbet tangan','b0ac04194b9841921d03c8514eebadf9008'),
	(188,'B','201801','201801','Tisu','96ab5cc2f028ce53d0d11e5964b76231e84'),
	(189,'B','201802','201802','Bahan pembersih lantai','451ca5ca2c6db8999da62b9797212e0aabb'),
	(190,'B','201901','201901','Perawatan bangunan','7e422d8c8f6829104d5cc25ab0643ada5ba'),
	(191,'B','201902','201902','Perbaikan toilet','11cb8bae9fb1e6fe2fd28467aaca0eadd5d'),
	(192,'B','202001','202001','Asuransi','16a9ef155d8347b366b1dc13887c70ac074'),
	(290,'B','202402','202402','Cover Rapot KB','3dff7c63458e1010075ac979859931c9b09'),
	(289,'B','202401','202401','Uang Gedung KB','19502caeca55491cbb38a3fb80d9d9ab3ba'),
	(196,'B','202101','202101','Pajak bangunan','93877243a753b941eab78a9be8ea185b2a2'),
	(197,'B','202102','202102','Peran masyarakat','4b80de6d6b1a0fb2a6eebf24090fab7e234'),
	(198,'B','202103','202103','Biaya Gedung','e8b3ed0ab3b41afcc64ea1802ebd7e01fec'),
	(199,'B','202104','202104','Overhead Kepersonaliaan &amp; akademik','c0a9603234fb5a509427045f5262bde42ed'),
	(288,'B','202304','202304','Psikotest','d676da154612037c32961ec1b6f495af874'),
	(201,'B','202201','202201','Buku Pelajaran KB','8e7e5259818414fa390bf103b8d7bf4bfbd'),
	(202,'B','202202','202202','Buku Tilawati KB','d2d37b889e1a2902f94740dbc51cf248d4e'),
	(287,'B','202303','202303','Seragam Yayasan Maroon','5defc70c1a4a0d5395f2af723cce1714022'),
	(286,'B','202302','202302','Buku Tilawati TK','ee77d39bae1482127ef53b7efede972e939'),
	(285,'B','202301','202301','Buku Pelajaran TK','eae7e71577e3f539fd3c3fff89e1b6dfa69'),
	(207,'B','201104','201104','Kegiatan Upgrading Guru','e10b0e03a5bfc30eaed048f76546ea2a331'),
	(245,'B','200634','200634','Karet gelang','87ae00c4397ee2b136aa3043a6a276579f2'),
	(244,'B','200633','200633','Box file','e9e8509b72d958aaf8d313937b9d13a03ae'),
	(242,'B','200415','200415','Kegiatan Edu Trip','72c12c6ea840a916967b5132567576847f8'),
	(243,'B','200416','200416','Kegiatan Akhir Tahun','14c909b93f0572774350c5135ff92baddcb'),
	(241,'B','200414','200414','Kegiatan PHBI (Maulid Nabi, Isro Mi&#039;roj)','d630881cd860bf9102ec5ee180d2b0f3cde'),
	(240,'B','200413','200413','Kegiatan Ramadhan berbagi &amp; tausiyah','555c267769f8f925ec117ea658cd00fb6a7'),
	(239,'B','200412','200412','Kegiatan Open House','bf9eeb6625b113b6ec0cfa409da4cfda46e'),
	(238,'B','200411','200411','Kegiatan Manasik Haji Anak','6347de7ea58afabe40aca2e5d6462c0f993'),
	(237,'B','200410','200410','Kegiatan Outing Class','b36b3ad0d379e62a2b7191a9c5a8a3cc293'),
	(236,'B','200409','200409','Kegiatan Archry for kids','a214210b612b919d2b75f928f3830c440a2'),
	(235,'B','200408','200408','Kegiatan Horse Riding','3009a8f76cff79137962213abb09f81630d'),
	(234,'B','200407','200407','Kegiatan Cooking Class','4c36ddda7b42968ebbb62c879e38eb5aeba'),
	(233,'B','200406','200406','Kegiatan Expert Arrival','d6688df476c2c7d97ba47bf0eb66abecddf'),
	(246,'B','200635','200635','Map holder','e8e162640f0a2985775f8d3bc667a6d35bd'),
	(247,'B','200636','200636','Odner file','dbedb1bcb4b13d60f38957482471acc0c1e'),
	(248,'B','200637','200637','Gunting besar','fba98cce89c2fdd2fad63ef9982dabb0423'),
	(249,'B','200638','200638','Lem tembak','afaee984acb2676830308db5c356e94dd43'),
	(250,'B','200639','200639','Plastik laminating','aa116c7c94ce207ac440e38d562c534c7bf'),
	(251,'B','200640','200640','Kertas HVS A4','4c5c0e5e6c8ee626a718b5ce71c8486fcc5'),
	(252,'B','200641','200641','Kertas HVS F4','fd676edf29796d0a18b63f5f9f0bd5099e5'),
	(253,'B','200643','200643','Cutter','2eafe2ccf7fb2bdce6e4ebceb1b33100f69'),
	(254,'B','200644','200644','Isi Cutter','d6a1cd07dabfa7e5ea964de28eb538c2415'),
	(255,'B','200642','200642','Kertas Rapor A4','727fe0a7183421691a09213cbb209112e17'),
	(256,'B','200645','200645','Tinta Printer','73ca02972464d133e2ad2904c8b627d78d9'),
	(257,'B','200702','200702','Amplop Sedang','3e9ce6f74e105f9598c48a03d83e0f561d0'),
	(258,'B','200703','200703','Amplop Kecil','7dc35cea71442eb324d7f09f9517bd14ec6'),
	(259,'B','200704','200704','Materai 10.000','b1ea9bb8bca9540d493778305923e8c6a18'),
	(268,'B','201603','201603','Buku referensi guru','fc84b3c024524e8e585cbc030143686f874'),
	(269,'B','201604','201604','Tempat sepatu','ef367ef7733b042a49da877b4753df0de13'),
	(270,'B','201605','201605','Buku perpustakaan','166d6987a8bd5b289cfb651039b7e3920ac'),
	(279,'B','201811','201811','Alat pel','e0db40f3e98422c8d471aa79d06755c0a90'),
	(280,'B','201812','201812','Alat kebersihan Lainnya','927406bdc77d34bcdbf5b986bd2d3681c67'),
	(281,'B','201813','201813','Peralatan dapur (galon, gelas, piring dll)','932e6fe70fe993bded0ed40e72742fa4376'),
	(282,'B','201814','201814','Pupuk taman','f371549aee8acc743f44025a08c8e88a0f0'),
	(283,'B','201815','201815','Peralatan maintenance (kuas, sikat, paku dll)','3513f740ffb0d66dda82af466ece9f5cbaf'),
	(284,'B','201903','201903','Perbaikan mebeler','55439127904e06c669fa53c5298c2b47620'),
	(291,'B','202403','202403','Seragam KB','4185b6ff06a30f2a6de39ef297d19bcc492'),
	(292,'B','202404','202404','Aplikasi PSP KB','918c95ed82d8a69c8255eeead5bf8b1bfbf'),
	(293,'B','202405','202405','Pas Foto KB','baf7663456e11bf57ea26f7290a712e6214'),
	(294,'B','202501','202501','Uang Gedung TK','38ad207a3150f41ca4bd9ce9dda1ef5e7f8'),
	(295,'B','202502','202502','Cover Rapot TK','be67cbb10e70f06d11a4c42e888c15ab85e'),
	(296,'B','202503','202503','Seragam TK','ba3f7cc721a162a3cfebbddd3a56091aecd'),
	(297,'B','202504','202504','Aplikasi PSP TK','6971e0f1f4fad93bdabb60c2dc1198066c2'),
	(298,'B','202505','202505','Pas Foto TK','1f0ba0077941dc6863eaa42086b48965e73'),
	(299,'B','200203','200203','Pelatihan Platform Merdeka Mengajar (PMM)','9e9bebb2682febc0187914e5d4180ec9ab6'),
	(300,'B','200646','200646','Tinta Sepidol','fadf96b2a6c47bb6f913bd3900ec8f7a626'),
	(301,'B','200647','200647','Daily Record','ba2d959a00f2120d254dfe2c39d12cd34cf'),
	(302,'B','202002','202002','BPJS','ce7c33ae075211ab51f25a72f1f8361e28e'),
	(303,'B','202003','202003','Overhead','872b94af2e168fb4bd3d77aa902ded54fe4'),
	(304,'B','201508','201508','Air Minum','d7f57c08befa16c4c3cf6aae13acda5023b'),
	(305,'B','202105','202105','Kebersihan dan keamanan Sekolah','bd42fb12a5d223cba421356782060a45a50'),
	(306,'B','202203','202203','Cover Sertifikat','20d432840b68a8a2eb1ca0cb6ce2f1d40b9'),
	(307,'B','202204','202204','Buku Do&#039;a dan Hadits','efa46b748973d40ca63116d82205075c552'),
	(308,'B','202305','202305','Cover Ijazah','baa7b45fd22d995227ad271ab8ecdc00e88'),
	(309,'B','202506','202506','Sovenir','05e72e77b1c455bcc7297d2b8a897f017d6');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_ref_kegiatan`;

CREATE TABLE IF NOT EXISTS `simakom_ref_kegiatan` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(100) NOT NULL,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `kegiatan_custome` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_ref_kegiatan` (`no`, `id`, `kategori`, `kegiatan`, `kegiatan_custome`, `uraian`) VALUES
	(112,'a9b7ba70783b617682775be85f192af3021','A','1000','1000','Penerimaan Saldo Tahun Lalu'),
	(113,'aa68c75c4a77c87eb516f153367af446a2d','A','1003','1003','Penerimaan Sumbangan Pemerintah'),
	(114,'5ec829debe54b19f0c285f19d5f8238d516','A','1999','1999','Penerimaan Lain'),
	(115,'b8c37e33defde5196797f48c50918cfed34','A','1001','1001','Penerimaan Pendapatan Asli sekolah'),
	(116,'08f90c1a41715530d57fb65210fd5641805','B','2000','2000','BELANJA PENGEMBANGAN KURIKULUM'),
	(117,'d0fb963ff976f9caa85c9573cde9eecc49c','B','2001','2001','BELANJA PENGEMBANGAN STANDARD PROSES'),
	(118,'4ba29b9f9e5732eba330560ce8dea080c85','B','2002','2002','BELANJA PENGEMBANGAN PENDIDIK DAN TENAGA  KEPENDIDIKAN'),
	(119,'a591024321c5e2be1e7995c3691c587c2b4','B','2003','2003','BELANJA PENGEMBANGAN STANDAR PENGELOLAAN'),
	(120,'b8b4b727d6f5d1b432ac766b69336db5531','B','2004','2004','BELANJA PENGEMBANGAN SARANA DAN PRASARANA'),
	(121,'d47268e9db2e9aa1a4664e16cca14a573a8','B','2005','2005','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN'),
	(122,'ea5a486c712a91e1a4664e16cca14a573a8','B','2006','2006','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN'),
	(123,'a00e5eb0973d246abeddaf41d228e0a578a','B','2007','2007','PENDAFTARAN SISWA BARU'),
	(124,'fba9d88164f3e2d5467853399716b596568','A','1002','1002','Penerimaan Uang Extra Kurikuler'),
	(125,'a36e841c5230a793c0924129aa796561a71','B','2999','2999','BELANJA LAINNYA'),
	(126,'fed33392d3a48aac9354242c284f97a5e37','A','1004','1004','Penerimaan Sumbangan Masyarakat');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_nama_bayar`;

CREATE TABLE IF NOT EXISTS `tb_nama_bayar` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(10) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kode` varchar(2) NOT NULL,
  `bulanan` varchar(10) NOT NULL,
  `id` varchar(15) NOT NULL,
  `blok` varchar(20) NOT NULL,
  `kelas` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_nama_bayar` (`no`, `tp`, `nama`, `kode`, `bulanan`, `id`, `blok`, `kelas`) VALUES
	(31,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A8','','11'),
	(32,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024A9','','12'),
	(34,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B10','','10'),
	(35,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B8','','11'),
	(36,'2023/2024','Sumbangan Operasional Sekolah (SOP)','B','Ya','2023/2024B9','','12'),
	(53,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C8','','11'),
	(54,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C9','','12'),
	(61,'2023/2024','Tanggungan Tahun Lalu','A','Tidak','2023/2024ALulus','','LULUS'),
	(62,'2023/2024','Uang Kegiatan','C','Tidak','2023/2024C7','','10'),
	(63,'2024/2025','SPP','B','Ya','2024/2025BTPA','','TPA'),
	(64,'2024/2025','SPP','B','Ya','2024/2025BKB','','KB'),
	(65,'2024/2025','SPP','B','Ya','2024/2025BTK','','TK'),
	(66,'2024/2025','SPP','B','Ya','2024/2025BLulus','','Lulus'),
	(67,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025CTPA','','TPA'),
	(68,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025CKB','','KB'),
	(69,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025CTK','','TK'),
	(70,'2024/2025','Biaya Pendidikan','C','Tidak','2024/2025CLulus','','Lulus'),
	(71,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025AKB','','KB'),
	(72,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025ATK','','TK'),
	(73,'2024/2025','Tunggakan Tahun lalu','A','Tidak','2024/2025ALulus','','Lulus'),
	(74,'2024/2025','Extrakurikuler','D','Ya','2024/2025DTPA','','TPA'),
	(75,'2024/2025','Extrakurikuler','D','Ya','2024/2025DKB','','KB'),
	(76,'2024/2025','Extrakurikuler','D','Ya','2024/2025DTK','','TK'),
	(77,'2024/2025','Extrakurikuler','D','Ya','2024/2025DLulus','','Lulus'),
	(78,'2024/2025','Kas Kelas','E','Ya','2024/2025ETPA','','TPA'),
	(79,'2024/2025','Kas Kelas','E','Ya','2024/2025EKB','','KB'),
	(80,'2024/2025','Kas Kelas','E','Ya','2024/2025ETK','','TK'),
	(81,'2024/2025','Kas Kelas','E','Ya','2024/2025ELulus','','Lulus'),
	(82,'2024/2025','Biaya Pendaftaran Siswa Baru','F','Tidak','2024/2025FTPA','','TPA'),
	(83,'2024/2025','Biaya Pendaftaran Siswa Baru','F','Tidak','2024/2025FKB','','KB'),
	(84,'2024/2025','Biaya Pendaftaran Siswa Baru','F','Tidak','2024/2025FTK','','TK'),
	(85,'2024/2025','Fullday','G','Tidak','2024/2025GTPA','','TPA'),
	(86,'2024/2025','Fullday','G','Tidak','2024/2025GKB','','KB'),
	(87,'2024/2025','Fullday','G','Tidak','2024/2025GTK','','TK'),
	(88,'2024/2025','Shadow Teacher','H','Ya','2024/2025HTPA','','TPA'),
	(89,'2024/2025','Shadow Teacher','H','Ya','2024/2025HKB','','KB'),
	(90,'2024/2025','Shadow Teacher','H','Ya','2024/2025HTK','','TK'),
	(91,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026ALulus','','Lulus'),
	(92,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026ATK','','TK'),
	(93,'2025/2026','Tunggakan Tahun lalu','A','Tidak','2025/2026AKB','','KB'),
	(94,'2025/2026','SPP','B','Ya','2025/2026BTPA','','TPA'),
	(95,'2025/2026','SPP','B','Ya','2025/2026BKB','','KB'),
	(96,'2025/2026','SPP','B','Ya','2025/2026BTK','','TK'),
	(97,'2025/2026','SPP','B','Ya','2025/2026BLulus','','Lulus'),
	(98,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026CLulus','','Lulus'),
	(99,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026CTK','','TK'),
	(100,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026CKB','','KB'),
	(101,'2025/2026','Biaya Pendidikan','C','Tidak','2025/2026CTPA','','TPA'),
	(102,'2025/2026','Extrakurikuler','D','Ya','2025/2026DLulus','','Lulus'),
	(103,'2025/2026','Extrakurikuler','D','Ya','2025/2026DTK','','TK'),
	(104,'2025/2026','Extrakurikuler','D','Ya','2025/2026DKB','','KB'),
	(105,'2025/2026','Extrakurikuler','D','Ya','2025/2026DTPA','','TPA'),
	(106,'2025/2026','Kas Kelas','E','Ya','2025/2026ETPA','','TPA'),
	(107,'2025/2026','Kas Kelas','E','Ya','2025/2026EKB','','KB'),
	(108,'2025/2026','Kas Kelas','E','Ya','2025/2026ETK','','TK'),
	(109,'2025/2026','Kas Kelas','E','Ya','2025/2026ELulus','','Lulus'),
	(110,'2025/2026','Pendaftaran Siswa Baru','F','Tidak','2025/2026FTK','','TK'),
	(111,'2025/2026','Pendaftaran Siswa Baru','F','Tidak','2025/2026FKB','','KB'),
	(112,'2025/2026','Pendaftaran Siswa Baru','F','Tidak','2025/2026FTPA','','TPA'),
	(113,'2025/2026','Fullday','G','Tidak','2025/2026GTPA','','TPA'),
	(114,'2025/2026','Fullday','G','Tidak','2025/2026GKB','','KB'),
	(115,'2025/2026','Fullday','G','Tidak','2025/2026GTK','','TK'),
	(116,'2025/2026','Shadow Teacher','H','Ya','2025/2026HTPA','','TPA'),
	(117,'2025/2026','Shadow Teacher','H','Ya','2025/2026HKB','','KB'),
	(118,'2025/2026','Shadow Teacher','H','Ya','2025/2026HTK','','TK');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_paralel`;

CREATE TABLE IF NOT EXISTS `tb_paralel` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `id` varchar(50) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `status` varchar(15) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_paralel` (`no`, `id`, `paralel`, `status`) VALUES
	(18,'9d5ed678fe57e75fa5704cf40','B1','Aktif'),
	(21,'0d61f8370cad82c486547f599','B2','Aktif'),
	(23,'7fc56270e7a70c1fbfac34ac2','A2','Aktif'),
	(25,'3a3ea00cfc35009f23e17ec68','1','Aktif'),
	(26,'800618943025ed73eb5b6b972','2','Aktif'),
	(27,'dfcf28d07345df1fb088c98f0','A1','Aktif'),
	(33,'e11c1bc57b97131059d58b826','LULUS','Aktif'),
	(34,'9d5ed678fe57a44466cd57d09','B','Aktif'),
	(35,'7fc56270e7a71566c562ae89a','A','Aktif');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_kategori`;

CREATE TABLE IF NOT EXISTS `tb_siswa_kategori` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(200) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_kategori` (`no`, `kategori`, `id`, `created_at`) VALUES
	(1,'Umum','919db3a7bfc497f00ddfb51592d','2023-05-24 05:31:46'),
	(4,'MMP','606670ce12a5a75f2ada86cae30','2023-07-31 08:44:47'),
	(5,'Akademik','1603223377224863b9c36f969e2','2023-07-31 08:44:57'),
	(6,'KKO','de3ad54b3bd47253639bd484582','2023-07-31 08:45:02');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_tp`;

CREATE TABLE IF NOT EXISTS `tb_tp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `backup` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tp` (`no`, `tp`, `backup`, `time`, `id`, `created_at`, `created_by`) VALUES
	(13,'2023/2024','','2023-07-10 14:24:48','5531a5834816c3f04945cbc9d','2023-07-10 14:24:48','113ccaa98a0a30bc5204ed2fccc9c515'),
	(16,'2024/2025','','2024-07-09 21:42:24','07811dc6c42276c5a4048af63','2024-07-09 21:42:24','50463efa59739fd6caf07114793ee291'),
	(17,'2025/2026','','2024-12-07 16:07:26','312351bff0792b8216c5bb69a','2024-12-07 16:07:26','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_walikelas`;

CREATE TABLE IF NOT EXISTS `tb_walikelas` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tp` varchar(9) NOT NULL,
  `jenjang` varchar(2) NOT NULL,
  `paralel` varchar(100) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `nip` varchar(18) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` varchar(100) NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_walikelas` (`no`, `tp`, `jenjang`, `paralel`, `nama`, `nip`, `id`, `created_at`, `created_by`) VALUES
	(1,'2024/2025','KB','1','E. Putri Halimah, S.Pd.TK/I','3213015208920001','a3757f2c8c2790ba2a56','2024-12-10 12:04:29','50463efa59739fd6caf07114793ee291'),
	(2,'2024/2025','KB','2','Santi Susilawati, S.Pd.','3203035909780001','fa7cc7374e286ba7a9f8','2024-12-10 12:05:38','50463efa59739fd6caf07114793ee291'),
	(3,'2024/2025','TK','A1','Devi Irniasari, S.Pd.','3213174108870003','04a455b78c01517f2c51','2024-12-10 12:06:41','50463efa59739fd6caf07114793ee291'),
	(4,'2024/2025','TK','A2','Lia Minhatul Maula, S.Pd.I','3213266708850003','01fee30801f3a7535797','2024-12-10 12:07:44','50463efa59739fd6caf07114793ee291'),
	(5,'2024/2025','TK','B','Sri Mulyani, S.Psi.I','3213175801850001','3b074100013888ac37be','2024-12-10 12:10:16','50463efa59739fd6caf07114793ee291');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `whatsapp`;

CREATE TABLE IF NOT EXISTS `whatsapp` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) NOT NULL,
  `sistem` varchar(2) NOT NULL,
  `key_api` text DEFAULT NULL,
  `server` text NOT NULL,
  `token` varchar(100) DEFAULT NULL,
  `device` varchar(15) DEFAULT NULL,
  `idinstance` text DEFAULT NULL,
  `admin` varchar(15) DEFAULT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `whatsapp` (`no`, `aktif`, `sistem`, `key_api`, `server`, `token`, `device`, `idinstance`, `admin`, `id`) VALUES
	(1,'','','','','0','','','0','8E73735D50169571C0680DDA603E6BC4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_periode`;

CREATE TABLE IF NOT EXISTS `tabungan_periode` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tahun` varchar(9) NOT NULL,
  `status` varchar(6) NOT NULL,
  `created_at` datetime NOT NULL,
  `closed_at` datetime DEFAULT NULL,
  `closed_by` varchar(100) DEFAULT NULL,
  `id` varchar(25) NOT NULL,
  PRIMARY KEY (`no`),
  UNIQUE KEY `tahun` (`tahun`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tabungan_periode` (`no`, `tahun`, `status`, `created_at`, `closed_at`, `closed_by`, `id`) VALUES
	(1,'2022/2023','close','2023-04-20 11:33:23','2023-10-03 05:06:19','tabungan','38eafdfa86559e303bd0'),
	(2,'2023/2024','open','2023-04-21 19:57:26','1901-01-01 00:00:00','','da6363e171cecab03bd0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_komponen2526`;

CREATE TABLE IF NOT EXISTS `simakom_komponen2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_komponen2526` (`no`, `kategori`, `kegiatan`, `komponen`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','AA','Penerimaan Saldo Kas dan Bank Tahun Lalu','A1000AA','7fc56270e7a70faa70783b6172dffc6cb0696a3b','0'),
	(2,'A','1000','AB','Penerimaan Saldo Piutang Tahun Lalu','A1000AB','7fc56270e7a70faa70783b6176b051f63d7a2ef4','0'),
	(3,'A','1001','AA','Penerimaan SPP','A1001AA','7fc56270e7a70fae33defde512dffc6cb06e45ee','0'),
	(4,'A','1001','AB','Penerimaan Biaya Pendidikan','A1001AB','7fc56270e7a70fae33defde516b051f63d77d066','0'),
	(5,'A','1002','AA','Penerimaan Uang Extra Kurikuler','A1002AA','7fc56270e7a70fa88164f3e2d2dffc6cb06751d3','0'),
	(6,'A','1003','AA','Sumbangan Pemerintah Pusat','A1003AA','7fc56270e7a70fa75c4a77c872dffc6cb06faeac','0'),
	(7,'A','1004','AA','Sumbangan Wakaf Infaq dan Sodaqoh','A1004AA','7fc56270e7a70fa392d3a48aa2dffc6cb06e1eee','0'),
	(8,'B','2000','BA','Penyusunan Kurikulum','B2000BA','9d5ed678fe57bccc1a41715530cf62601dffad6f','0'),
	(9,'B','2000','BB','Proses Pembelajaran dan Evaluasi','B2000BB','9d5ed678fe57bccc1a4171553048db16a7e28fd0','0'),
	(10,'B','2000','BD','Pengembangan Kegiatan Pembelajaran','B2000BD','9d5ed678fe57bccc1a4171553565be4714784eb1','0'),
	(11,'B','2001','BA','Penerimaan Peserta Didik Baru (PPDB)','B2001BA','9d5ed678fe57bcc63ff976f9c0cf62601dfd2490','0'),
	(12,'B','2001','BB','Alat Pendukung Proses Pembelajaran / ATK','B2001BB','9d5ed678fe57bcc63ff976f9c048db16a7e44195','0'),
	(13,'B','2001','BC','Pembelian Benda POS','B2001BC','9d5ed678fe57bcc63ff976f9cb377112c270e510','0'),
	(14,'B','2001','BD','Peralatan kesehatan dan keselamatan','B2001BD','9d5ed678fe57bcc63ff976f9c565be47147af032','0'),
	(15,'B','2001','BE','Pembelian Alat / Bahan Penunjang KBM','B2001BE','9d5ed678fe57bcc63ff976f9c429c679f9a73f76','0'),
	(16,'B','2002','BA','Rapat Kerja Guru dan Pegawai','B2002BA','9d5ed678fe57bccb9f9e5732e0cf62601df738cc','0'),
	(17,'B','2002','BB','Honorarium','B2002BB','9d5ed678fe57bccb9f9e5732e048db16a7e7658d','0'),
	(18,'B','2002','BC','Pengembangan Manajemen Sekolah','B2002BC','9d5ed678fe57bccb9f9e5732eb377112c279c3ce','0'),
	(19,'B','2003','BA','Rapat Pengelolaan Sekolah','B2003BA','9d5ed678fe57bcc24321c5e2b0cf62601df8f03a','0'),
	(20,'B','2003','BB','Langganan daya dan jasa','B2003BB','9d5ed678fe57bcc24321c5e2b048db16a7ef803d','0'),
	(22,'B','2004','BA','Pemeliharaan Kelas','B2004BA','9d5ed678fe57bcc727d6f5d1b0cf62601df8fc4c','0'),
	(25,'B','2005','BA','Pembiayaan Program Pembelajaran','B2005BA','9d5ed678fe57bcc8e9db2e9aa0cf62601df2c621','0'),
	(26,'B','2005','BB','Pembiayaan lain-lain','B2005BB','9d5ed678fe57bcc8e9db2e9aa048db16a7e3994f','0'),
	(27,'B','2006','BA','Perlengkapan Siswa KB','B2006BA','9d5ed678fe57bcc86c712a91e0cf62601dfcf2e4','0'),
	(28,'B','2007','BA','Perlengkapan Siswa Baru KB','B2007BA','9d5ed678fe57bcceb0973d2460cf62601df5c7d5','0'),
	(29,'B','2999','BA','Belanja Lainnya','B2999BA','9d5ed678fe57bcc41c5230a790cf62601df9f9ce','0'),
	(30,'B','2001','BF','Konsumsi Siswa','B2001BF','9d5ed678fe57bcc63ff976f9cf92148f52c7d06a','0'),
	(31,'B','2006','BB','Perlengkapan Siswa TK','B2006BB','9d5ed678fe57bcc86c712a91e048db16a7e26180','0'),
	(32,'B','2007','BB','Perlengkapan Siswa Baru TK','B2007BB','9d5ed678fe57bcceb0973d246048db16a7eb6aea','0'),
	(33,'B','2000','BC','Pelaksanaan Pembinaan Lomba','B2000BC','9d5ed678fe57bccc1a4171553b377112c27842f3','0'),
	(34,'A','1001','AC','Penerimaan Uang Pendaftaran Siswa Baru','A1001AC','7fc56270e7a70fae33defde51097d2fa7a42a452','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_kegiatan2526`;

CREATE TABLE IF NOT EXISTS `simakom_kegiatan2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_kegiatan2526` (`no`, `kategori`, `kegiatan`, `uraian`, `kode_id`, `id`, `revisi`) VALUES
	(1,'A','1000','Penerimaan Saldo Tahun Lalu','A1000','7fc56270e7a70faa70783b617e9998dc4dd96a3b','0'),
	(2,'A','1001','Penerimaan Pendapatan Asli sekolah','A1001','7fc56270e7a70fae33defde51cf91e1e03ea2ef4','0'),
	(3,'A','1002','Penerimaan Uang Extra Kurikuler','A1002','7fc56270e7a70fa88164f3e2d9109ee7702e45ee','0'),
	(4,'A','1003','Penerimaan Sumbangan Pemerintah','A1003','7fc56270e7a70fa75c4a77c87f97fb686b27d066','0'),
	(5,'A','1004','Penerimaan Sumbangan Masyarakat','A1004','7fc56270e7a70fa392d3a48aa149a87a38b73f76','0'),
	(6,'A','1999','Penerimaan Lain','A1999','7fc56270e7a70fa9debe54b19a5f78d9a65faeac','0'),
	(7,'B','2000','BELANJA PENGEMBANGAN KURIKULUM','B2000','9d5ed678fe57bccc1a417155361a5c4b8d2d72d1','0'),
	(8,'B','2001','BELANJA PENGEMBANGAN STANDARD PROSES','B2001','9d5ed678fe57bcc63ff976f9c37fc81fe03fad6f','0'),
	(9,'B','2002','BELANJA PENGEMBANGAN PENDIDIKAN DAN TENAGA PENDIDIK','B2002','9d5ed678fe57bccb9f9e5732ed33761840f0a800','0'),
	(10,'B','2003','BELANJA PENGEMBANGAN STANDAR PENGELOLAAN','B2003','9d5ed678fe57bcc24321c5e2bdbd23ed35fea20a','0'),
	(11,'B','2004','BELANJA PENGEMBANGAN SARANA DAN PRASARANA','B2004','9d5ed678fe57bcc727d6f5d1b61fff7be6884eb1','0'),
	(12,'B','2005','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN','B2005','9d5ed678fe57bcc8e9db2e9aa3827bba3afd2490','0'),
	(13,'B','2006','BELANJA PENGEMBANGAN STANDAR PEMBIAYAAN','B2006','9d5ed678fe57bcc86c712a91e48443cd80244195','0'),
	(14,'B','2007','PENERIMAAN SISWA BARU','B2007','9d5ed678fe57bcceb0973d24649a4a920fc0e510','0'),
	(15,'B','2999','BELANJA LAINNYA','B2999','9d5ed678fe57bcc41c5230a79c2102036d2af032','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_akun2526`;

CREATE TABLE IF NOT EXISTS `simakom_akun2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `uraian` text NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `akun_id` varchar(15) NOT NULL,
  `id` varchar(100) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=180 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_akun2526` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `uraian`, `kode_id`, `akun_id`, `id`, `revisi`) VALUES
	(1,'B','2000','BA',200101,'Penyusunan KOSP (KB & TK)','B2000BA','B2000200101BA','9d5ed678fec1a41715530cf62601df94c5054df5','0'),
	(2,'B','2000','BA',200102,'Penyusunan ATP dan Modul Ajar','B2000BA','B2000200102BA','9d5ed678fec1a41715530cf62601df1ef7eb67bf','0'),
	(3,'B','2000','BA',200103,'Penyusunan Program Kegiatan & Eskul (RAKER)','B2000BA','B2000200103BA','9d5ed678fec1a41715530cf62601dfe43c3e344c','0'),
	(158,'B','2000','BB',200203,'Pelatihan Platform Merdeka Mengajar (PMM)','B2000BB','B2000200203BB','b26829d5ed90c1a048db16a7eee539e93e3618cbe725-06','0'),
	(6,'B','2000','BC',200301,'Lomba Kedinasan','B2000BC','B2000200301BC','9d5ed678fec1a4171553b377112c279e62378d9e','0'),
	(7,'B','2000','BD',200401,'Kegiatan Fristday Activity','B2000BD','B2000200401BD','9d5ed678fec1a4171553565be4714742aa9f55ca','0'),
	(8,'B','2000','BD',200402,'Kegiatan Fieldtrip','B2000BD','B2000200402BD','9d5ed678fec1a4171553565be4714727f7b59671','0'),
	(9,'B','2000','BD',200403,'Kegiatan Lomba Kemerdekaan','B2000BD','B2000200403BD','9d5ed678fec1a4171553565be47147b20a5116dc','0'),
	(159,'B','2000','BD',200404,'Kegiatan Aquatic','B2000BD','B2000200404BD','c1fea9d5ed90c1a565be4714701a8bc2354cbaea3625-06','0'),
	(11,'B','2000','BD',200405,'Kegiatan Medical Check-up/Dental Check-up','B2000BD','B2000200405BD','9d5ed678fec1a4171553565be47147715b0dba75','0'),
	(12,'B','2000','BD',200406,'Kegiatan Expert Arrival','B2000BD','B2000200406BD','9d5ed678fec1a4171553565be47147df476fbc01','0'),
	(13,'B','2000','BD',200407,'Kegiatan Cooking Class','B2000BD','B2000200407BD','9d5ed678fec1a4171553565be47147dda7bca622','0'),
	(14,'B','2000','BD',200408,'Kegiatan Horse Riding','B2000BD','B2000200408BD','9d5ed678fec1a4171553565be471478f76c8bae7','0'),
	(15,'B','2000','BD',200409,'Kegiatan Archry for kids','B2000BD','B2000200409BD','9d5ed678fec1a4171553565be4714710b6196a0b','0'),
	(160,'B','2000','BD',200410,'Kegiatan Outing Class','B2000BD','B2000200410BD','d0d379d5ed90c1a565be4714701a8bc2354cbaea3625-06','0'),
	(19,'B','2000','BD',200413,'Kegiatan Ramadhan berbagi & tausiyah','B2000BD','B2000200413BD','9d5ed678fec1a4171553565be4714767769c81c2','0'),
	(20,'B','2000','BD',200414,'Kegiatan PHBI (Maulid Nabi, Isro Mi\'roj)','B2000BD','B2000200414BD','9d5ed678fec1a4171553565be4714781cd8a5aad','0'),
	(161,'B','2000','BD',200415,'Kegiatan Edu Trip','B2000BD','B2000200415BD','6ea849d5ed90c1a565be4714701a8bc2354cbaea3625-06','0'),
	(22,'B','2000','BD',200416,'Kegiatan Akhir Tahun','B2000BD','B2000200416BD','9d5ed678fec1a4171553565be471479b93f40975','0'),
	(23,'B','2001','BA',200501,'Promosi Sekolah (Iklan Digital, Stand\", event lomba, Trial Class)','B2001BA','B2001200501BA','9d5ed678fe63ff976f9c0cf62601df7a2b35e90a','0'),
	(25,'B','2001','BA',200503,'Kegiatan Home Visit (wawancara calon walisiswa)','B2001BA','B2001200503BA','9d5ed678fe63ff976f9c0cf62601df81a0ba4e23','0'),
	(26,'B','2001','BA',200504,'Panitia PPDB','B2001BA','B2001200504BA','9d5ed678fe63ff976f9c0cf62601df45d067f1a6','0'),
	(27,'B','2001','BB',200601,'Kertas lipat','B2001BB','B2001200601BB','9d5ed678fe63ff976f9c048db16a7ecb7c79e97a','0'),
	(28,'B','2001','BB',200602,'Kertas karton','B2001BB','B2001200602BB','9d5ed678fe63ff976f9c048db16a7eb006ff7d63','0'),
	(29,'B','2001','BB',200603,'Pensil','B2001BB','B2001200603BB','9d5ed678fe63ff976f9c048db16a7e4f4947d9a2','0'),
	(164,'B','2001','BB',200647,'Daily Record','B2001BB','B2001200647BB','9a00f9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(31,'B','2001','BB',200605,'Ballpoint','B2001BB','B2001200605BB','9d5ed678fe63ff976f9c048db16a7ec17be12195','0'),
	(32,'B','2001','BB',200606,'Spidol Whiteboard','B2001BB','B2001200606BB','9d5ed678fe63ff976f9c048db16a7e05d09b7056','0'),
	(34,'B','2001','BB',200608,'Tinta stampel','B2001BB','B2001200608BB','9d5ed678fe63ff976f9c048db16a7e4a769d972d','0'),
	(162,'B','2001','BB',200646,'Tinta Sepidol','B2001BB','B2001200646BB','b2a6c9d5edb963f048db16a7eee539e93e3618cbe725-06','0'),
	(36,'B','2001','BB',200610,'Penggaris','B2001BB','B2001200610BB','9d5ed678fe63ff976f9c048db16a7ea51c5164cc','0'),
	(37,'B','2001','BB',200611,'Type x','B2001BB','B2001200611BB','9d5ed678fe63ff976f9c048db16a7e1b17656c66','0'),
	(38,'B','2001','BB',200612,'Penghapus papan tulis','B2001BB','B2001200612BB','9d5ed678fe63ff976f9c048db16a7edf6dd0cf06','0'),
	(39,'B','2001','BB',200613,'Lem Uhu','B2001BB','B2001200613BB','9d5ed678fe63ff976f9c048db16a7e20653e7c1d','0'),
	(40,'B','2001','BB',200614,'Lem Fox','B2001BB','B2001200614BB','9d5ed678fe63ff976f9c048db16a7e24ae8605b3','0'),
	(41,'B','2001','BB',200615,'Stapler','B2001BB','B2001200615BB','9d5ed678fe63ff976f9c048db16a7e65b3e2b860','0'),
	(42,'B','2001','BB',200616,'Isi stapler kecil, sedang, besar','B2001BB','B2001200616BB','9d5ed678fe63ff976f9c048db16a7ed365d66e78','0'),
	(43,'B','2001','BB',200617,'Paper clip','B2001BB','B2001200617BB','9d5ed678fe63ff976f9c048db16a7e33650eb37b','0'),
	(44,'B','2001','BB',200618,'Binder clip','B2001BB','B2001200618BB','9d5ed678fe63ff976f9c048db16a7e55db817bad','0'),
	(45,'B','2001','BB',200619,'Stop map','B2001BB','B2001200619BB','9d5ed678fe63ff976f9c048db16a7e040b2abe2f','0'),
	(46,'B','2001','BB',200620,'Sneilheckter','B2001BB','B2001200620BB','9d5ed678fe63ff976f9c048db16a7eff42c66f42','0'),
	(47,'B','2001','BB',200621,'Kertas jilid/cover','B2001BB','B2001200621BB','9d5ed678fe63ff976f9c048db16a7eb637ad60d2','0'),
	(48,'B','2001','BB',200622,'Plastik Jilid / kertas mika','B2001BB','B2001200622BB','9d5ed678fe63ff976f9c048db16a7eb97b16c052','0'),
	(49,'B','2001','BB',200623,'Lakban bening kecil','B2001BB','B2001200623BB','9d5ed678fe63ff976f9c048db16a7e9968378013','0'),
	(50,'B','2001','BB',200624,'Lakban bening besar','B2001BB','B2001200624BB','9d5ed678fe63ff976f9c048db16a7eb7f18c8e58','0'),
	(51,'B','2001','BB',200625,'Lakban hitam','B2001BB','B2001200625BB','9d5ed678fe63ff976f9c048db16a7e34e88cb9d1','0'),
	(52,'B','2001','BB',200626,'Lakban kertas','B2001BB','B2001200626BB','9d5ed678fe63ff976f9c048db16a7ed5ec6d8e43','0'),
	(53,'B','2001','BB',200627,'Doubletip','B2001BB','B2001200627BB','9d5ed678fe63ff976f9c048db16a7e5082800fde','0'),
	(54,'B','2001','BB',200628,'Double Foam','B2001BB','B2001200628BB','9d5ed678fe63ff976f9c048db16a7ece89262a8d','0'),
	(55,'B','2001','BB',200629,'Label stiker','B2001BB','B2001200629BB','9d5ed678fe63ff976f9c048db16a7eb534e059ff','0'),
	(56,'B','2001','BB',200630,'Kertas kado','B2001BB','B2001200630BB','9d5ed678fe63ff976f9c048db16a7e5d96d6cc50','0'),
	(57,'B','2001','BB',200631,'Kertas Kopi','B2001BB','B2001200631BB','9d5ed678fe63ff976f9c048db16a7ec1d1603747','0'),
	(58,'B','2001','BB',200632,'Goody bag','B2001BB','B2001200632BB','9d5ed678fe63ff976f9c048db16a7e2f954e6fb2','0'),
	(59,'B','2001','BB',200633,'Box file','B2001BB','B2001200633BB','9d5ed678fe63ff976f9c048db16a7e09b7217b4a','0'),
	(60,'B','2001','BB',200634,'Karet gelang','B2001BB','B2001200634BB','9d5ed678fe63ff976f9c048db16a7e0c439755e9','0'),
	(61,'B','2001','BB',200635,'Map holder','B2001BB','B2001200635BB','9d5ed678fe63ff976f9c048db16a7e2640f54e0f','0'),
	(62,'B','2001','BB',200636,'Odner file','B2001BB','B2001200636BB','9d5ed678fe63ff976f9c048db16a7e1bcb47dd50','0'),
	(63,'B','2001','BB',200637,'Gunting besar','B2001BB','B2001200637BB','9d5ed678fe63ff976f9c048db16a7ecce8965b6f','0'),
	(64,'B','2001','BB',200638,'Lem tembak','B2001BB','B2001200638BB','9d5ed678fe63ff976f9c048db16a7e984acf9bb7','0'),
	(65,'B','2001','BB',200639,'Plastik laminating','B2001BB','B2001200639BB','9d5ed678fe63ff976f9c048db16a7ec7c94e3f2f','0'),
	(66,'B','2001','BB',200640,'Kertas HVS A4','B2001BB','B2001200640BB','9d5ed678fe63ff976f9c048db16a7ee5e6c17a72','0'),
	(67,'B','2001','BB',200641,'Kertas HVS F4','B2001BB','B2001200641BB','9d5ed678fe63ff976f9c048db16a7eedf299e6d4','0'),
	(68,'B','2001','BB',200642,'Kertas Rapor A4','B2001BB','B2001200642BB','9d5ed678fe63ff976f9c048db16a7e0a718f7f65','0'),
	(69,'B','2001','BB',200643,'Cutter','B2001BB','B2001200643BB','9d5ed678fe63ff976f9c048db16a7e2ccf71bfbf','0'),
	(70,'B','2001','BB',200644,'Isi Cutter','B2001BB','B2001200644BB','9d5ed678fe63ff976f9c048db16a7ed07daa2e11','0'),
	(71,'B','2001','BB',200645,'Tinta Printer','B2001BB','B2001200645BB','9d5ed678fe63ff976f9c048db16a7e297249e80d','0'),
	(72,'B','2001','BC',200701,'Amplop Besar (Coklat)','B2001BC','B2001200701BC','9d5ed678fe63ff976f9cb377112c270b5a405e48','0'),
	(73,'B','2001','BC',200702,'Amplop Sedang','B2001BC','B2001200702BC','9d5ed678fe63ff976f9cb377112c276f74e8a3fc','0'),
	(74,'B','2001','BC',200703,'Amplop Kecil','B2001BC','B2001200703BC','9d5ed678fe63ff976f9cb377112c27cea7183241','0'),
	(75,'B','2001','BC',200704,'Materai 10.000','B2001BC','B2001200704BC','9d5ed678fe63ff976f9cb377112c27bb8bca5b06','0'),
	(76,'B','2001','BD',200801,'Masker','B2001BD','B2001200801BD','9d5ed678fe63ff976f9c565be471479752bd04fe','0'),
	(77,'B','2001','BD',200802,'Obat - Obatan UKS','B2001BD','B2001200802BD','9d5ed678fe63ff976f9c565be47147971ec761b0','0'),
	(165,'B','2001','BE',200901,'Pengadaan alat olahraga','B2001BE','B2001200901BE','3f1ac9d5edb963f429c679f9af82eb9a3b31c4df4425-06','0'),
	(166,'B','2001','BE',200902,'Pengadaan bahan praktik Mapel','B2001BE','B2001200902BE','840969d5edb963f429c679f9af82eb9a3b31c4df4425-06','0'),
	(81,'B','2001','BF',201001,'Snack Siswa','B2001BF','B2001201001BF','9d5ed678fe63ff976f9cf92148f52c27daea9b2b','0'),
	(82,'B','2001','BF',201002,'Makan Besar','B2001BF','B2001201002BF','9d5ed678fe63ff976f9cf92148f52c9a03f198f9','0'),
	(84,'B','2002','BA',201101,'Kegiatan IGTKI','B2002BA','B2002201101BA','9d5ed678feb9f9e5732e0cf62601df54f6a0c82a','0'),
	(85,'B','2002','BA',201102,'Kegiatan Gugus','B2002BA','B2002201102BA','9d5ed678feb9f9e5732e0cf62601df9c0111640f','0'),
	(88,'B','2002','BB',201201,'Perjalanan Dinas dan Humas','B2002BB','B2002201201BB','9d5ed678feb9f9e5732e048db16a7e20596b94d7','0'),
	(91,'B','2002','BC',201301,'Seragam Guru dan Karyawan','B2002BC','B2002201301BC','9d5ed678feb9f9e5732eb377112c2735b5b8ba9c','0'),
	(93,'B','2003','BA',201401,'Rapat wali murid awal , parenting','B2003BA','B2003201401BA','9d5ed678fe24321c5e2b0cf62601df1979f85664','0'),
	(94,'B','2003','BA',201402,'Rapat wali murid Akhir Tahun','B2003BA','B2003201402BA','9d5ed678fe24321c5e2b0cf62601df45ec53c0ae','0'),
	(97,'B','2003','BB',201503,'Mintenance AC','B2003BB','B2003201503BB','9d5ed678fe24321c5e2b048db16a7ed4b9880736','0'),
	(98,'B','2003','BB',201504,'Pulsa Operator TK','B2003BB','B2003201504BB','9d5ed678fe24321c5e2b048db16a7e7e8ca31a67','0'),
	(99,'B','2003','BB',201505,'Maintenance mobil dan motor operasional','B2003BB','B2003201505BB','9d5ed678fe24321c5e2b048db16a7e037abd8315','0'),
	(100,'B','2003','BB',201506,'Maintenance Printer','B2003BB','B2003201506BB','9d5ed678fe24321c5e2b048db16a7e28e7733708','0'),
	(101,'B','2003','BB',201507,'Maintenance Komputer/Laptop','B2003BB','B2003201507BB','9d5ed678fe24321c5e2b048db16a7e528f7c9fdb','0'),
	(108,'B','2004','BA',201702,'Hiasan kelas','B2004BA','B2004201702BA','9d5ed678fe727d6f5d1b0cf62601df6638624a41','0'),
	(179,'B','2007','BB',202506,'Sovenir','B2007BB','B2007202506BB','77b1c9d5ede5eb0048db16a7eee539e93e3618cbe725-06','0'),
	(178,'B','2007','BA',202506,'Sovenir','B2007BA','B2007202506BA','77b1c9d5ede5eb00cf62601df84b7923b9964c53e625-06','0'),
	(177,'B','2006','BB',202305,'Cover Ijazah','B2006BB','B2006202305BB','5fd229d5eda486c048db16a7eee539e93e3618cbe725-06','0'),
	(172,'B','2005','BA',201508,'Air Minum','B2005BA','B2005201508BA','08bef9d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(168,'B','2005','BA',201501,'Listrik','B2005BA','B2005201501BA','72fdb9d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(169,'B','2005','BA',201502,'Wifi + Telepon','B2005BA','B2005201502BA','bc9af9d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(170,'B','2005','BA',202002,'BPJS','B2005BA','B2005202002BA','ae0759d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(171,'B','2005','BA',202003,'Overhead','B2005BA','B2005202003BA','af2e19d5ed268e90cf62601df84b7923b9964c53e625-06','0'),
	(127,'B','2005','BA',202001,'Asuransi','B2005BA','B2005202001BA','9d5ed678fe8e9db2e9aa0cf62601dff155d19a6a','0'),
	(128,'B','2005','BB',202101,'Pajak bangunan','B2005BB','B2005202101BB','9d5ed678fe8e9db2e9aa048db16a7e243a7df680','0'),
	(175,'B','2006','BA',202204,'Buku Do\'a dan Hadits','B2006BA','B2006202204BA','748979d5eda486c0cf62601df84b7923b9964c53e625-06','0'),
	(173,'B','2005','BB',202105,'Kebersihan dan keamanan Sekolah','B2005BB','B2005202105BB','12a5d9d5ed268e9048db16a7eee539e93e3618cbe725-06','0'),
	(174,'B','2006','BA',202203,'Cover Sertifikat','B2006BA','B2006202203BA','840b69d5eda486c0cf62601df84b7923b9964c53e625-06','0'),
	(132,'B','2006','BA',202201,'Buku Pelajaran KB','B2006BA','B2006202201BA','9d5ed678fe86c712a91e0cf62601df25981aa763','0'),
	(133,'B','2006','BA',202202,'Buku Tilawati KB','B2006BA','B2006202202BA','9d5ed678fe86c712a91e0cf62601dfb889edd972','0'),
	(134,'B','2006','BB',202301,'Buku Pelajaran TK','B2006BB','B2006202301BB','9d5ed678fe86c712a91e048db16a7e71577fd472','0'),
	(135,'B','2006','BB',202302,'Buku Tilawati TK','B2006BB','B2006202302BB','9d5ed678fe86c712a91e048db16a7e39bae490b6','0'),
	(176,'B','2006','BB',202204,'Buku Do\'a dan Hadits','B2006BB','B2006202204BB','748979d5eda486c048db16a7eee539e93e3618cbe725-06','0'),
	(137,'B','2006','BB',202304,'Psikotest','B2006BB','B2006202304BB','9d5ed678fe86c712a91e048db16a7ea1546f655f','0'),
	(138,'B','2007','BA',202401,'Uang Gedung KB','B2007BA','B2007202401BA','9d5ed678feeb0973d2460cf62601dfcaeca4ee9e','0'),
	(139,'B','2007','BA',202402,'Cover Rapot KB','B2007BA','B2007202402BA','9d5ed678feeb0973d2460cf62601dfc6345d647f','0'),
	(140,'B','2007','BA',202403,'Seragam KB','B2007BA','B2007202403BA','9d5ed678feeb0973d2460cf62601df6ff06df790','0'),
	(141,'B','2007','BA',202404,'Aplikasi PSP KB','B2007BA','B2007202404BA','9d5ed678feeb0973d2460cf62601df5ed8286564','0'),
	(142,'B','2007','BA',202405,'Pas Foto KB','B2007BA','B2007202405BA','9d5ed678feeb0973d2460cf62601df63456b66e0','0'),
	(143,'B','2007','BB',202501,'Uang Gedung TK','B2007BB','B2007202501BB','9d5ed678feeb0973d246048db16a7e07a31e0bc5','0'),
	(144,'B','2007','BB',202502,'Cover Rapot TK','B2007BB','B2007202502BB','9d5ed678feeb0973d246048db16a7ebb10edbea8','0'),
	(145,'B','2007','BB',202503,'Seragam TK','B2007BB','B2007202503BB','9d5ed678feeb0973d246048db16a7ecc721520ff','0'),
	(146,'B','2007','BB',202504,'Aplikasi PSP TK','B2007BB','B2007202504BB','9d5ed678feeb0973d246048db16a7e0f1f4ed798','0'),
	(147,'B','2007','BB',202505,'Pas Foto TK','B2007BB','B2007202505BB','9d5ed678feeb0973d246048db16a7e0077920752','0'),
	(148,'A','1000','AA',100000,'Penerimaan Saldo Kas Tahun Lalu','A1000AA','A1000100000AA','7fc56270e7a70783b6172dffc6cb062eabae1433','0'),
	(149,'A','1000','AA',100001,'Penerimaan Saldo Bank Tahun Lalu','A1000AA','A1000100001AA','7fc56270e7a70783b6172dffc6cb061ace354b5e','0'),
	(150,'A','1000','AB',100002,'Penerimaan Pembayaran Piutang Tahun lalu','A1000AB','A1000100002AB','7fc56270e7a70783b6176b051f63d734eb623bb8','0'),
	(151,'A','1001','AA',100101,'Penerimaan SPP','A1001AA','A1001100101AA','7fc56270e7e33defde512dffc6cb0676ec835071','0'),
	(152,'A','1001','AB',100102,'Penerimaan Biaya Pendidikan','A1001AB','A1001100102AB','7fc56270e7e33defde516b051f63d7a338dfadb8','0'),
	(153,'A','1002','AA',100201,'Penerimaan Biaya Extrakurikuler','A1002AA','A1002100201AA','7fc56270e788164f3e2d2dffc6cb063f13efaf4c','0'),
	(154,'A','1003','AA',100301,'Bantuan Operasional Sekolah (BOP)','A1003AA','A1003100301AA','7fc56270e775c4a77c872dffc6cb06a0c102c7cd','0'),
	(155,'A','1004','AA',100401,'Sumbangan Wakaf Infaq dan Sodaqoh','A1004AA','A1004100401AA','7fc56270e7392d3a48aa2dffc6cb0648a5af5e10','0'),
	(156,'A','1001','AC',100103,'Penerimaan Biaya Pendaftaran Siswa Baru','A1001AC','A1001100103AC','7fc56270e7e33defde51097d2fa7a4ff44c088ea','0'),
	(167,'B','2005','BA',201203,'Honor Guru dan Pegawai','B2005BA','B2005201203BA','127ad9d5ed268e90cf62601df84b7923b9964c53e625-06','0');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_detail2526`;

CREATE TABLE IF NOT EXISTS `simakom_detail2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `kategori` varchar(1) NOT NULL,
  `kegiatan` varchar(4) NOT NULL,
  `komponen` varchar(5) NOT NULL,
  `akun` float NOT NULL,
  `detail` float NOT NULL,
  `detail_id` varchar(20) NOT NULL,
  `uraian` text NOT NULL,
  `volume` varchar(15) NOT NULL,
  `satuan` varchar(50) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `total` varchar(15) NOT NULL,
  `komponen_1` varchar(10) NOT NULL,
  `komponen_2` varchar(10) NOT NULL,
  `komponen_3` varchar(10) NOT NULL,
  `komponen_4` varchar(10) NOT NULL,
  `unit_1` varchar(100) NOT NULL,
  `unit_2` varchar(100) NOT NULL,
  `unit_3` varchar(100) NOT NULL,
  `unit_4` varchar(100) NOT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `time` datetime NOT NULL,
  `kode_id` varchar(20) NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=174 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_detail2526` (`no`, `kategori`, `kegiatan`, `komponen`, `akun`, `detail`, `detail_id`, `uraian`, `volume`, `satuan`, `unit`, `total`, `komponen_1`, `komponen_2`, `komponen_3`, `komponen_4`, `unit_1`, `unit_2`, `unit_3`, `unit_4`, `pembiayaan_id`, `pembiayaan_kegiatan`, `pembiayaan_komponen`, `pembiayaan_akun`, `revisi`, `time`, `kode_id`, `id`) VALUES
	(1,'A','1000','AA',100000,1,'A1000AA10000000100','Penerimaan Saldo Kas Tahun Lalu','1','0','Paket','0','','','','','','','','','','','','','0','2025-06-23 16:08:14','A1000AA','eab3d34a4230849508495cd98f096a3b'),
	(2,'A','1000','AA',100001,1,'A1000AA10000100100','Penerimaan Saldo Bank Tahun Lalu','1','0','Paket','0','','','','','','','','','','','','','0','2025-06-23 16:08:14','A1000AA','acef7b8a4230849508495cd98f0a2ef4'),
	(3,'A','1000','AB',100002,1,'A1000AB10000200100','Penerimaan Pembayaran Piutang Tahun lalu','1','0','Paket','0','','','','','','','','','','','','','0','2025-06-23 16:08:14','A1000AB','4eb8327a4230849508495cd98f0e45ee'),
	(4,'A','1001','AA',100101,1,'A1001AA10010100100','Penerimaan SPP','1','309720000','Tahun','309720000','','','','','','','','','','','','','0','2025-07-09 13:29:46','A1001AA','6ec3ce9a42308a8808a88cd98f07d066'),
	(5,'A','1001','AB',100102,1,'A1001AB10010200100','Penerimaan Biaya Pendidikan','1','360500000','Tahun','360500000','','','','','','','','','','','','','0','2025-07-09 13:29:12','A1001AB','338a738a4231bc9e1bc9ecd98f0751d3'),
	(6,'A','1001','AC',100103,1,'A1001AC10010300100','Penerimaan Biaya Pendaftaran Siswa Baru','1','0','Paket','0','','','','','','','','','','','','','0','2025-06-23 16:08:14','A1001AC','f44f24aa4230849508495cd98f0faeac'),
	(7,'A','1002','AA',100201,1,'A1002AA10020100100','Penerimaan Biaya Pendaftaran Siswa Baru','1','0','Paket','0','','','','','','','','','','','','','0','2025-06-23 16:08:14','A1002AA','f13f24aa4230849508495cd98f0d72d1'),
	(8,'B','2000','BA',200101,1,'B2000BA20010100100','Penyusunan KOSP (KB &amp; TK)','2','200000','Paket','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:29:41','B2000BA','4c5f38be728d2829a0e8ea338d7fad6f'),
	(9,'B','2000','BA',200102,1,'B2000BA20010200100','Penyusunan ATP dan Modul Ajar','1','500000','Paket','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2000BA','ef73544a423732a2732a2a338d70a800'),
	(10,'B','2000','BA',200103,1,'B2000BA20010300100','Penyusunan Program Kegiatan &amp; Eskul (RAKER)','1','300000','Paket','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2000BA','43c3cdaa42304ce904ce9a338d7ea20a'),
	(152,'B','2000','BB',200203,1,'B2000BB20020300100','Pelatihan Platform Merdeka Mengajar (PMM)','2','320000','Paket','640000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:35:12','B2000BB','b269a49e728ba935780435a79a338d71'),
	(13,'B','2000','BC',200301,1,'B2000BC20030100100','Lomba Kedinasan','10','100000','Paket','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:31:00','B2000BC','e621c912bd42eaba42123a338d744195'),
	(14,'B','2000','BD',200401,1,'B2000BD20040100100','Kegiatan Fristday Activity','61','5000','Paket','305000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:35:54','B2000BD','2aa24cebf412741f29735a338d70e510'),
	(15,'B','2000','BD',200402,1,'B2000BD20040200100','Kegiatan Fieldtrip','61','25000','Paket','1525000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:36:17','B2000BD','7f75108bf415381001141a338d7af032'),
	(16,'B','2000','BD',200403,1,'B2000BD20040300100','Kegiatan Lomba Kemerdekaan','61','25000','Paket','1525000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:22:13','B2000BD','20a9f6fbf41cdf31f0216a338d773f76'),
	(153,'B','2000','BD',200404,1,'B2000BD20040400100','Kegiatan Aquatic','122','7500','Siswa','915000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:26:40','B2000BD','c1f48e2080f13c82898fab95ca338d71'),
	(18,'B','2000','BD',200405,1,'B2000BD20040500100','Kegiatan Medical Check-up/Dental Check-up','61','25000','Paket','1525000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:27:56','B2000BD','15b289f605f13150fd148a338d77658d'),
	(19,'B','2000','BD',200406,1,'B2000BD20040600100','Kegiatan Expert Arrival','61','7500','Paket','457500','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:28:35','B2000BD','f4761b5bf41cdf31f0216a338d79c3ce'),
	(20,'B','2000','BD',200407,1,'B2000BD20040700100','Kegiatan Cooking Class','61','10000','Paket','610000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:29:50','B2000BD','da7d457bf412741f29735a338d78f03a'),
	(21,'B','2000','BD',200408,1,'B2000BD20040800100','Kegiatan Horse Riding','61','10000','Paket','610000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:30:43','B2000BD','f76fd07bf412741f29735a338d7f803d'),
	(22,'B','2000','BD',200409,1,'B2000BD20040900100','Kegiatan Archry for kids','61','5000','Paket','305000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:32:21','B2000BD','0b62763bf412741f29735a338d77f514'),
	(154,'B','2000','BD',200410,1,'B2000BD20041000100','Kegiatan Outing Class','61','100000','Orang','6100000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:35:59','B2000BD','d0dbb3c9f832eaba29adb4b2aa338d71'),
	(26,'B','2000','BD',200413,1,'B2000BD20041300100','Kegiatan Ramadhan berbagi &amp; tausiyah','61','5000','Paket','305000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:45:24','B2000BD','7764a8fbf412741f29735a338d72c621'),
	(27,'B','2000','BD',200414,1,'B2000BD20041400100','Kegiatan PHBI (Maulid Nabi, Isro Mi&#039;roj)','61','12000','Paket','732000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:38:54','B2000BD','1cd935fbf41cdf31f0216a338d73994f'),
	(155,'B','2000','BD',200415,1,'B2000BD20041500100','Kegiatan Edu Trip','61','200000','Paket','12200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:42:37','B2000BD','6ea04969f8361603f69ba3b38a338d71'),
	(29,'B','2000','BD',200416,1,'B2000BD20041600100','Kegiatan Akhir Tahun','61','250000','Paket','15250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:43:15','B2000BD','b932213bf41dd62b8c985a338d75c7d5'),
	(30,'B','2001','BA',200501,1,'B2001BA20050100100','Promosi Sekolah (Iklan Digital, Stand&quot;, event lomba, Trial Class)','1','3000000','Paket','3000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:46:01','B2001BA','a2b8941a423318de318dea338d79f9ce'),
	(32,'B','2001','BA',200503,1,'B2001BA20050300100','Kegiatan Home Visit (wawancara calon walisiswa)','61','10000','Paket','610000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:47:43','B2001BA','1a0769ebf41886c788319a338d79ac05'),
	(33,'B','2001','BA',200504,1,'B2001BA20050400100','Panitia PPDB','61','15000','Paket','915000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 08:48:21','B2001BA','5d00ce8bf41886c788319a338d71732c'),
	(34,'B','2001','BB',200601,1,'B2001BB20060100100','Kertas lipat','122','15000','Paket','1830000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:03:45','B2001BB','b7cecf6605f886c71ae23a338d7e1eee'),
	(35,'B','2001','BB',200602,1,'B2001BB20060200100','Kertas karton','61','10000','Pcs','610000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:04:17','B2001BB','0061d1ebf412741f29735a338d77d06a'),
	(36,'B','2001','BB',200603,1,'B2001BB20060300100','Pensil','20','2000','Pcs','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:05:34','B2001BB','f49c3a1fb5c8bdc163e10a338d726180'),
	(38,'B','2001','BB',200605,1,'B2001BB20060500100','Ballpoint','2','20000','Pak','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:08:18','B2001BB','17bcd110f89cdf3141ebca338d7842f3'),
	(39,'B','2001','BB',200606,1,'B2001BB20060600100','Spidol Whiteboard','2','90000','Pak','180000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','5d03338e728526ad9cbb9a338d72a452'),
	(157,'B','2001','BB',200647,1,'B2001BB20064700100','Daily Record','61','20000','Pcs','1220000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:14:07','B2001BB','9a017c09f83cdf31c06895ed8a338d71'),
	(41,'B','2001','BB',200608,1,'B2001BB20060800100','Tinta stampel','1','30000','Pcs','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:44:39','B2001BB','a7624f3e728131506dd7ea338d7a27ef'),
	(156,'B','2001','BB',200646,1,'B2001BB20064600100','Tinta Sepidol','1','75000','Pak','75000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:43:51','B2001BB','b2ac781a423b1bb4f5b1bb4f5a338d71'),
	(43,'B','2001','BB',200610,1,'B2001BB20061000100','Penggaris','4','15000','Pcs','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:45:12','B2001BB','51cd6530f89886c737ad0a338d72f1ee'),
	(44,'B','2001','BB',200611,1,'B2001BB20061100100','Type x','8','15000','Pcs','120000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:46:23','B2001BB','b17ccafce41886c70ac80a338d7bff82'),
	(45,'B','2001','BB',200612,1,'B2001BB20061200100','Penghapus papan tulis','6','10000','Pcs','60000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','f6dea0e90912741f6dd7ea338d7e46d0'),
	(46,'B','2001','BB',200613,1,'B2001BB20061300100','Lem Uhu','31','30000','Pcs','930000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:47:10','B2001BB','065ec0959201315086626a338d7bf97f'),
	(47,'B','2001','BB',200614,1,'B2001BB20061400100','Lem Fox','31','27000','Pcs','837000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:47:40','B2001BB','4aea84c59208f5430f724a338d72c4a8'),
	(48,'B','2001','BB',200615,1,'B2001BB20061500100','Stapler','2','20000','Pcs','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','5b38747e728cdf31048a2a338d76d4a6'),
	(49,'B','2001','BB',200616,1,'B2001BB20061600100','Isi stapler kecil, sedang, besar','3','25000','Pak','75000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','365a164bc8753810b1bb4a338d765cfe'),
	(50,'B','2001','BB',200617,1,'B2001BB20061700100','Paper clip','5','5000','Pak','25000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','3650c32a3b77f7fe53810a338d7a3458'),
	(51,'B','2001','BB',200618,1,'B2001BB20061800100','Binder clip','3','35000','Pak','105000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:48:50','B2001BB','5db2220a3b797dcdd1daea338d78c961'),
	(52,'B','2001','BB',200619,1,'B2001BB20061900100','Stop map','3','30000','Pak','90000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:49:20','B2001BB','40bef63a3b713150dd62ba338d7a71d8'),
	(53,'B','2001','BB',200620,1,'B2001BB20062000100','Sneilheckter','3','30000','Pak','90000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','f42aa79bc8713150526ada338d75759d'),
	(54,'B','2001','BB',200621,1,'B2001BB20062100100','Kertas jilid/cover','3','40000','Pak','120000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:51:34','B2001BB','637ea5ea3b7048a261603a338d7f75c3'),
	(55,'B','2001','BB',200622,1,'B2001BB20062200100','Plastik Jilid / kertas mika','3','45000','Pak','135000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:52:07','B2001BB','97b3491a3b7224573d388a338d7b7923'),
	(56,'B','2001','BB',200623,1,'B2001BB20062300100','Lakban bening kecil','1','30000','Pak','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','96835f0a4231315013150a338d788dda'),
	(57,'B','2001','BB',200624,1,'B2001BB20062400100','Lakban bening besar','1','50000','Pak','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','7f1c89aa423fd467fd467a338d7671f8'),
	(58,'B','2001','BB',200625,1,'B2001BB20062500100','Lakban hitam','10','15000','Pcs','150000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 09:53:01','B2001BB','4e84d291370886c704ce9a338d7e7db5'),
	(59,'B','2001','BB',200626,1,'B2001BB20062600100','Lakban Kertas','2','5000','Pak','10000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','5ec9effe7287f7fe2741fa338d768267'),
	(60,'B','2001','BB',200627,1,'B2001BB20062700100','Doubletip','10','8000','Pcs','80000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','082627594462d40fd8be8a338d703b90'),
	(61,'B','2001','BB',200628,1,'B2001BB20062800100','Double Foam','12','8000','Pcs','96000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','e89188bad4d2d40f95ff1a338d7307fd'),
	(62,'B','2001','BB',200629,1,'B2001BB20062900100','Label stiker','3','5000','Pak','15000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','534916abc877f7fe886c7a338d718230'),
	(63,'B','2001','BB',200630,1,'B2001BB20063000100','Kertas kado','1','35000','Pak','35000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','d96a0f2a42397dcd97dcda338d7f157b'),
	(64,'B','2001','BB',200631,1,'B2001BB20063100100','Kertas Kopi','5','15000','Pak','75000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','1d1f95ea3b7886c7b1bb4a338d7b34f3'),
	(65,'B','2001','BB',200632,1,'B2001BB20063200100','Goody bag','61','12000','Pcs','732000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:00:02','B2001BB','f95a62e605f2741ff0216a338d7a91f7'),
	(66,'B','2001','BB',200633,1,'B2001BB20063300100','Box file','2','15000','Pcs','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','9b7cc32e728886c713150a338d77ba15'),
	(67,'B','2001','BB',200634,1,'B2001BB20063400100','Karet gelang','1','20000','Pak','20000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','c4327f4a423cdf31cdf31a338d784150'),
	(68,'B','2001','BB',200635,1,'B2001BB20063500100','Map Holder','1','25000','Pak','25000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','640afb3a4235381053810a338d7fb849'),
	(69,'B','2001','BB',200636,1,'B2001BB20063600100','Odner file','9','25000','Pak','225000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','bcb961748cc538103d388a338d7275a9'),
	(70,'B','2001','BB',200637,1,'B2001BB20063700100','Gunting besar','3','15000','Pcs','45000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','ce83eabbc87886c722457a338d7a7228'),
	(71,'B','2001','BB',200638,1,'B2001BB20063800100','Lem tembak','1','65000','Pak','65000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','84ad243a4231d0f81d0f8a338d7a74b5'),
	(72,'B','2001','BB',200639,1,'B2001BB20063900100','Plastik laminating','1','90000','Pak','90000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','7c9242ea423526ad526ada338d7c4258'),
	(73,'B','2001','BB',200640,1,'B2001BB20064000100','Kertas HVS A4','50','49000','Rim','2450000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:03:25','B2001BB','5e6e58e8154ef14b12f3ea338d7871c1'),
	(74,'B','2001','BB',200641,1,'B2001BB20064100100','Kertas HVS F4','50','50000','Rim','2500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:04:46','B2001BB','df251228154ef14b12f3ea338d731c8f'),
	(75,'B','2001','BB',200642,1,'B2001BB20064200100','Kertas Rapor A4','2','125000','Rim','250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:05:45','B2001BB','a710216ff67c2cef732a2a338d7207f4'),
	(76,'B','2001','BB',200643,1,'B2001BB20064300100','Cutter','1','20000','Pak','20000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','ccf3f73a423cdf31cdf31a338d7ba55f'),
	(77,'B','2001','BB',200644,1,'B2001BB20064400100','Isi Cutter','1','30000','Pak','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BB','07de06fa4231315013150a338d7a8614'),
	(78,'B','2001','BB',200645,1,'B2001BB20064500100','Tinta Printer','20','100000','Pcs','2000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:07:12','B2001BB','97266fba14e2eaba63154a338d7b1e0a'),
	(79,'B','2001','BC',200701,1,'B2001BC20070100100','Amplop Besar (Coklat)','1','15000','Pak','15000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:14:57','B2001BC','b5a03bce728886c713150a338d738b18'),
	(80,'B','2001','BC',200702,1,'B2001BC20070200100','Amplop Sedang','2','25000','Pak','50000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BC','f747692e72853810fd467a338d731b7b'),
	(81,'B','2001','BC',200703,1,'B2001BC20070300100','Amplop Kecil','2','20000','Pak','40000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:17:50','B2001BC','ea7471ce728cdf31048a2a338d713c02'),
	(82,'B','2001','BC',200704,1,'B2001BC20070400100','Materai 10.000','30','10000','Pcs','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2001BC','b8b8b8573cb2741f04ce9a338d706eb1'),
	(83,'B','2001','BD',200801,1,'B2001BD20080100100','Masker','1','30000','Pak','30000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:20:39','B2001BD','752bbc4e728131506dd7ea338d718bbc'),
	(84,'B','2001','BD',200802,1,'B2001BD20080200100','Obat - Obatan UKS','2','200000','Pak','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:19:28','B2001BD','71ee277e728dd62b04ce9a338d737bc1'),
	(158,'B','2001','BE',200901,1,'B2001BE20090100100','Pengadaan alat olahraga','1','250000','Pack','250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:31:50','B2001BE','3f15cafa42355e038c55e038ca338d71'),
	(159,'B','2001','BE',200902,1,'B2001BE20090200100','Pengadaan bahan praktik Mapel','1','300000','Pack','300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:32:57','B2001BE','8409b9fa42304ce9ba04ce9baa338d71'),
	(88,'B','2001','BF',201001,1,'B2001BF20100100100','Snack Siswa','10','1600000','Bulan','16000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:38:00','B2001BF','7da6e81ad4da06a7498dba338d7d5f03'),
	(89,'B','2001','BF',201002,1,'B2001BF20100200100','Makan Besar','10','305000','Bulan','3050000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:35:25','B2001BF','a0395add2080849508495a338d75072d'),
	(91,'B','2002','BA',201101,1,'B2002BA20110100100','Kegiatan IGTKI','12','110000','Bulan','1320000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:39:12','B2002BA','4f6fb24ad4dfd467a425fa338d7d2716'),
	(92,'B','2002','BA',201102,1,'B2002BA20110200100','Kegiatan Gugus','12','20000','Pack','240000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 10:39:49','B2002BA','c017d4090912741f6dd7ea338d7e6477'),
	(160,'B','2003','BA',201402,1,'B2003BA20140200100','Rapat wali murid Akhir Tahun','61','15000','Paket','915000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:17:55','B2003BA','5ecfdc89f83886c7f88fab95ca338d71'),
	(95,'B','2002','BB',201201,1,'B2002BB20120100100','Perjalanan Dinas dan Humas','12','100000','Bulan','1200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2002BB','0599088ad4d2eaba86626a338d7fb9ce'),
	(99,'B','2002','BC',201301,1,'B2002BC20130100100','Seragam Guru dan Karyawan','13','250000','Orang','3250000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:13:41','B2002BC','5b5b9c0ad4d04ce963154a338d786380'),
	(100,'B','2003','BA',201401,1,'B2003BA20140100100','Rapat wali murid awal , parenting','61','15000','Paket','915000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:16:14','B2003BA','9795d4c605f886c71ae23a338d7db2f4'),
	(101,'B','2003','BB',201503,1,'B2003BB20150300100','Mintenance AC','6','300000','Paket','1800000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:36:09','B2003BB','4b9e7be9091a425f63154a338d7814f0'),
	(102,'B','2003','BB',201504,1,'B2003BB20150400100','Pulsa Operator TK','12','105000','Bulan','1260000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2003BB','e8c093fad4d713cabfd68a338d7d81b9'),
	(103,'B','2003','BB',201505,1,'B2003BB20150500100','Maintenance mobil dan motor operasional','1','1000000','Bulan','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:37:41','B2003BB','37addc6ad4ddd62bc2fe4a338d7b0f07'),
	(104,'B','2003','BB',201506,1,'B2003BB20150600100','Maintenance Printer','2','200000','Paket','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:38:34','B2003BB','8e7137aa4236160361603a338d7be6c5'),
	(105,'B','2003','BB',201507,1,'B2003BB20150700100','Maintenance Komputer/Laptop','1','1000000','Paket','1000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:38:58','B2003BB','28f996fa4237cfba7cfbaa338d728b0e'),
	(112,'B','2004','BA',201702,1,'B2004BA20170200100','Hiasan kelas','6','200000','Paket','1200000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 11:44:43','B2004BA','638156ea3b761603c545fa338d707aeb'),
	(173,'B','2007','BB',202506,1,'B2007BB20250600100','Sovenir','8','130000','Pcs','1040000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:11:59','B2007BB','77b464b0f89b405260d8b9261a338d71'),
	(172,'B','2007','BA',202506,1,'B2007BA20250600100','Sovenir','13','130000','Pcs','1690000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:05:03','B2007BA','77b464bce41b4052604131fe9a338d71'),
	(171,'B','2006','BB',202305,1,'B2006BB20230500100','Cover Ijazah','48','35000','Siswa','1680000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:51:32','B2006BB','5fd5679e92e97dcd8363c3de4a338d71'),
	(166,'B','2005','BA',201508,1,'B2005BA20150800100','Air Minum','12','450000','Bulan','5400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 12:22:51','B2005BA','08bb5baad4d1c580ae47956baa338d71'),
	(165,'B','2005','BA',202003,1,'B2005BA20200300100','Overhead','1','10000000','Paket','10000000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 12:18:08','B2005BA','af2d48da423aaf52b4aaf52b4a338d71'),
	(161,'B','2005','BA',201203,1,'B2005BA20120300100','Honor Guru dan Pegawai','13','25182000','Bulan','327366000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-24 12:08:52','B2005BA','127ee1ece41a5f7a36134639776ec85f'),
	(162,'B','2005','BA',201501,1,'B2005BA20150100100','Listrik','12','1505000','Bulan','18060000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-24 12:10:14','B2005BA','72f49e0ad4dbb8d8fad4f5dab76ec85f'),
	(163,'B','2005','BA',201502,1,'B2005BA20150200100','Wifi + Telepon','12','412500','Bulan','4950000','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-24 12:11:55','B2005BA','bc98b75ad4d130d1b521b160476ec85f'),
	(164,'B','2005','BA',202002,1,'B2005BA20200200100','BPJS','12','3412731','Bulan','40952772','','','','','','','','','A1001AA10010100100','1001','AA','100101','0','2025-06-24 12:17:05','B2005BA','ae0c697ad4df3d461ef2cdffa76ec85f'),
	(133,'B','2005','BA',202001,1,'B2005BA20200100100','Asuransi','61','50000','Paket','3050000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 12:24:05','B2005BA','155d436bf4197dcd1309ca338d711927'),
	(134,'B','2005','BB',202101,1,'B2005BB20210100100','Pajak Bangunan','1','1300000','Tahun','1300000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-23 16:08:14','B2005BB','43a7d95a4236e4906e490a338d7a9bd0'),
	(169,'B','2006','BA',202204,1,'B2006BA20220400100','Buku Do&#039;a dan Hadits','13','20000','Siswa','260000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:28:44','B2006BA','748368ece41cdf31c08c29876a338d71'),
	(167,'B','2005','BB',202105,1,'B2005BB20210500100','Kebersihan dan keamanan Sekolah','12','200000','Bulan','2400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:20:29','B2005BB','12ae841ad4d61603f62c3da6ca338d71'),
	(168,'B','2006','BA',202203,1,'B2006BA20220300100','Cover Sertifikat','13','35000','Siswa','455000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:27:38','B2006BA','8407cb3ce4197dcd83ad2ae4ca338d71'),
	(138,'B','2006','BA',202201,1,'B2006BA20220100100','Buku Pelajaran KB','13','315000','Paket','4095000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:29:28','B2006BA','598be8e96a0da11a76450a338d761c0a'),
	(139,'B','2006','BA',202202,1,'B2006BA20220200100','Buku Tilawati KB','13','15000','Paket','195000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:30:26','B2006BA','8896caf96a01d0f8f9918a338d7ea831'),
	(140,'B','2006','BB',202301,1,'B2006BB20230100100','Buku Pelajaran TK','48','448000','Paket','21504000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:45:07','B2006BB','157d8707c76c78c69af70a338d740c0e'),
	(141,'B','2006','BB',202302,1,'B2006BB20230200100','Buku Tilawati TK','48','15000','Paket','720000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:45:52','B2006BB','9ba9b517c761d0f82c31ca338d72323c'),
	(170,'B','2006','BB',202204,1,'B2006BB20220400100','Buku Do&#039;a dan Hadits','48','20000','Siswa','960000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:48:48','B2006BB','748368ee92ecdf31c0a19d366a338d71'),
	(143,'B','2006','BB',202304,1,'B2006BB20230400100','Psikotest','48','200000','Paket','9600000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 13:46:31','B2006BB','15471637c7661603aaf52a338d742812'),
	(144,'B','2007','BA',202402,1,'B2007BA20240200100','Cover Rapot KB','13','50000','Pcs','650000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:01:27','B2007BA','634bb2a96a0fd467507a6a338d75150e'),
	(145,'B','2007','BA',202403,1,'B2007BA20240300100','Seragam KB','13','585000','Pcs','7605000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:02:14','B2007BA','ff006a496a060c3f9add8a338d7be30a'),
	(146,'B','2007','BA',202405,1,'B2007BA20240500100','Pas Foto KB','13','20000','Pcs','260000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:03:49','B2007BA','345120396a0cdf31732a2a338d740948'),
	(147,'B','2007','BA',202404,1,'B2007BA20240400100','Aplikasi PSP KB','13','50000','Pcs','650000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:02:55','B2007BA','ed84ce696a0fd467507a6a338d7612b9'),
	(148,'B','2007','BB',202502,1,'B2007BB20250200100','Cover Rapot TK','48','50000','Pcs','2400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:06:37','B2007BB','b10221b7c76fd4673c92ea338d7bda8f'),
	(149,'B','2007','BB',202503,1,'B2007BB20250300100','Seragam TK','8','880000','Pcs','7040000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:13:33','B2007BB','c7283787c7660c3f7c302a338d7f0bb9'),
	(150,'B','2007','BB',202504,1,'B2007BB20250400100','Aplikasi PSP TK','8','50000','Pcs','400000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:07:48','B2007BB','f1f8c947c76fd4673c92ea338d7f80f7'),
	(151,'B','2007','BB',202505,1,'B2007BB20250500100','Pas Foto TK','25','20000','Pcs','500000','','','','','','','','','A1001AB10010200100','1001','AB','100102','0','2025-06-24 14:09:59','B2007BB','0779c957c76cdf31c545fa338d7b356b');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_jurnal2526`;

CREATE TABLE IF NOT EXISTS `simakom_jurnal2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `id` varchar(40) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_revisi2526`;

CREATE TABLE IF NOT EXISTS `simakom_revisi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `revisi` float NOT NULL,
  `tanggal` date NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `simakom_revisi2526` (`no`, `revisi`, `tanggal`, `time`, `id`) VALUES
	(1,'0','2025-06-23','2025-06-23 16:08:13','6ffcc95e5c1d1a5cd3ddb81a6418fd467f8');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_transaksi2526`;

CREATE TABLE IF NOT EXISTS `simakom_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `bukti` float NOT NULL,
  `bukti_sistem` float NOT NULL,
  `jenis` float NOT NULL,
  `kategori` varchar(3) NOT NULL,
  `rkas_kategori` varchar(1) NOT NULL,
  `rkas_kegiatan` varchar(5) NOT NULL,
  `rkas_komponen` varchar(5) NOT NULL,
  `rkas_akun` float NOT NULL,
  `rkas_detail_id` varchar(25) NOT NULL,
  `uraian` text NOT NULL,
  `debet` varchar(15) NOT NULL,
  `kredit` varchar(15) NOT NULL,
  `penerima` varchar(100) DEFAULT NULL,
  `penerima_jabatan` varchar(100) DEFAULT NULL,
  `pembiayaan_id` varchar(50) NOT NULL,
  `pembiayaan_kegiatan` varchar(4) NOT NULL,
  `pembiayaan_komponen` varchar(5) NOT NULL,
  `pembiayaan_akun` varchar(6) NOT NULL,
  `pajak` tinyint(1) NOT NULL,
  `pajak_akun` varchar(10) NOT NULL,
  `revisi` varchar(10) NOT NULL,
  `id_setor` varchar(25) NOT NULL,
  `time` datetime NOT NULL,
  `id` varchar(100) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `simakom_lpj2526`;

CREATE TABLE IF NOT EXISTS `simakom_lpj2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `periode` varchar(2) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `bku_awal` varchar(15) NOT NULL,
  `bku_debet` varchar(15) NOT NULL,
  `bku_kredit` varchar(15) NOT NULL,
  `bku_akhir` varchar(15) NOT NULL,
  `bank_awal` varchar(15) NOT NULL,
  `bank_debet` varchar(15) NOT NULL,
  `bank_kredit` varchar(15) NOT NULL,
  `bank_akhir` varchar(15) NOT NULL,
  `tunai_awal` varchar(15) NOT NULL,
  `tunai_debet` varchar(15) NOT NULL,
  `tunai_kredit` varchar(15) NOT NULL,
  `tunai_akhir` varchar(15) NOT NULL,
  `bank_riil` varchar(15) NOT NULL,
  `tunai_riil` varchar(15) NOT NULL,
  `bank_selisih` varchar(15) NOT NULL,
  `tunai_selisih` varchar(15) NOT NULL,
  `selisihtunai_keterangan1` text NOT NULL,
  `selisihtunai_keterangan2` text NOT NULL,
  `selisihbank_keterangan1` text NOT NULL,
  `selisihbank_keterangan2` text NOT NULL,
  `rekening_nama1` text NOT NULL,
  `rekening_jumlah1` varchar(15) NOT NULL,
  `rekening_nama2` text NOT NULL,
  `rekening_jumlah2` varchar(15) NOT NULL,
  `rekening_nama3` text NOT NULL,
  `rekening_jumlah3` varchar(15) NOT NULL,
  `catatan` text NOT NULL,
  `pecahan_100` varchar(10) NOT NULL,
  `pecahan_75` varchar(10) NOT NULL,
  `pecahan_50` varchar(10) NOT NULL,
  `pecahan_20` varchar(10) NOT NULL,
  `pecahan_10` varchar(10) NOT NULL,
  `pecahan_5` varchar(10) NOT NULL,
  `pecahan_2` varchar(10) NOT NULL,
  `pecahan_1` varchar(10) NOT NULL,
  `pecahan_05` varchar(10) NOT NULL,
  `pecahan_02` varchar(10) NOT NULL,
  `pecahan_01` varchar(10) NOT NULL,
  `pecahan_005` varchar(10) NOT NULL,
  `id` varchar(30) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_setor2526`;

CREATE TABLE IF NOT EXISTS `db_setor2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal_draf` datetime NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `uraian` text NOT NULL,
  `setor_status` varchar(10) NOT NULL,
  `setor_tanggal` datetime NOT NULL,
  `terima_status` varchar(10) NOT NULL,
  `terima_tanggal` datetime NOT NULL,
  `penyetor` varchar(50) NOT NULL,
  `penerima` varchar(50) NOT NULL,
  `metode` varchar(2) NOT NULL,
  `id_rkas` varchar(50) NOT NULL,
  `tahun` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa_min2526`;

CREATE TABLE IF NOT EXISTS `tb_siswa_min2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=418 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa_min2526` (`no`, `nama`, `nis`, `jenjang`, `paralel`, `id`) VALUES
	(347,'ZAHRA SHABIRA HAMDANI','24.11.24.312','KB','1','af19fb42dd4995673cd1'),
	(348,'AGAM AHMAD AL RUBY','24.11.24.303','KB','1','6f81e2aebcabb3e2dd96'),
	(349,'ALZIO SYAFIQ','25.11.24.001','KB','1','520a815e2f2930a92b1d'),
	(350,'APRIZIO ADZKAR RAZEL','25.11.24.002','KB','1','b3bd5d0e3d2a23601149'),
	(351,'AQILA SHAFA NADINE','25.11.24.003','KB','1','0cba2e5a1ab4fe0a3464'),
	(352,'AZALEA QALESYA ZALINDRA','25.11.24.004','KB','1','9d27ad16d273ee43abdf'),
	(353,'EMIL ARSENIO FATCHURAHMAN','25.11.24.005','KB','1','ce266cbd0dfc360b84e0'),
	(354,'IMARA PRADITA GANTARI','25.11.24.006','KB','1','2759a808617adb0a8fcf'),
	(355,'JA&amp;#039;FAR SHODIQ ALI','25.11.24.007','KB','1','3ba13deb3f922c2e0c13'),
	(356,'MALAYKA NUR ADEEVA ABDURRAHMAN','25.11.24.008','KB','1','5433653c10f3bb6450d4'),
	(357,'RAYYAN ALTAIR PRATAMA','25.11.24.009','KB','1','67b4c5e9ef040590a04b'),
	(358,'QHAIRA ADARA NUR PUTRI REFIANDI','25.11.24.010','KB','1','b9d64e8c684295bedc27'),
	(359,'GAFFI ATHALLA DZIKRI','25.11.24.011','KB','1','645b62279fe1c80f4723'),
	(360,'ALYA AZZAHRA ALFATHUNNISA','24.11.24.290','TK','A','69e07a9b7900c8b52143'),
	(361,'ASHRAF DZAMAAR RAFISQY SIDDIQ','24.11.24.292','TK','A','2813a7ff658bb140bfac'),
	(362,'ATHAYYA DZAKA AFANDHI KUSNANTO','24.11.24.293','TK','A','0aee28288b48f57698bb'),
	(363,'SHAQILA NESYA AR-RASYID','24.11.24.301','TK','A','cd2f30f1fcbf9c5df345'),
	(364,'ZARA ARRAWFA NAYANIKA','24.11.24.302','TK','A','7cb9320b308d51d341bc'),
	(365,'CHAIRA KHALIFANI YAHYA','24.11.24.304','TK','A','e48f4289865646527bb2'),
	(366,'KALANDRA ABRISAM IBRAHIM','24.11.24.307','TK','A','43be73362b1f36811376'),
	(367,'SYAHNAZ MAFAZA ADLILLAH POHAN','24.11.23.276','TK','A','8e6dbb4a7eeb5c6b089c'),
	(368,'VELICA KIERAN SLAMET GHUMAISHA','24.11.23.277','TK','A','072bff9a946b07beba75'),
	(369,'ABYAN ALIF FIRDAUS','25.11.24.012','TK','A','754c6bc75334f6f591e1'),
	(370,'ANDINY LAQUITTA PUTRIWIBOWO','25.11.24.013','TK','A','765fc13eb7caf0ab7187'),
	(371,'DARREN ACHAZIA RINALDI','25.11.24.014','TK','A','c9be0521a2e649305cb6'),
	(372,'DIAN AZKA UTAMI','25.11.24.015','TK','A','c9b823ad9d59a134b10f'),
	(373,'EL FATIH ATHARIZ PRATAMA','25.11.24.016','TK','A','343ce59983b851aef213'),
	(374,'FATHIR SHIDQI DHIAULHAQ','25.11.24.017','TK','A','3dca4bac94e5ab43b8e3'),
	(375,'HAFIZH ZHAFRAN RAMDHANI','25.11.24.018','TK','A','449400c39a3a48917049'),
	(376,'HABIBIE MUSTHAFA RAMADHAN','25.11.24.019','TK','A','a205b5ae0d655261631a'),
	(377,'HELENA BRIGZYA SAUSA PRABOWO','25.11.24.020','TK','A','026f52ea217cd97fd519'),
	(378,'KANAYAA MAULIDYA SUDARMAN ','25.11.24.021','TK','A','619a9bf730f8f4044eaf'),
	(379,'KHAIRIN NISAK HANAFIAH','25.11.24.022','TK','A','4073ea1ae587174f474b'),
	(380,'MUHAMMAD NUR ALDIZAR SUYANTO','25.11.24.023','TK','B','daa7123471eee8d8cce5'),
	(381,'MUHAMMAD RAYYANDRA ZULFIKAR AL FATIH','25.11.24.025','TK','A','1740d7b08afec57b8451'),
	(382,'MUHAMMAD ZEESHAN PERBAWA','25.11.24.026','TK','A','856b6bdd942bd33c9604'),
	(383,'NAHDA FAIHA SIREGAR','25.11.24.028','TK','A','fcdbf88ae7ea872f3309'),
	(384,'NAURA RASHA AZKIYA','25.11.24.029','TK','A','1c122e9131e53369c527'),
	(385,'NAUSHAD WALDAN KURNIAWAN','25.11.24.030','TK','A','c0626726fdba6ff2665e'),
	(386,'HAYKAL NEVAN ABHISEVA','25.11.24.031','TK','A','019afe34baf2a625af95'),
	(387,'AFIYA NASYITA MUNANDAR','24.22.24.304','TK','B','44ebd3b586d8a312f912'),
	(388,'HAFY RASYID ADSKHAN','24.22.24.306','TK','B','55c446145f35eb9e3b65'),
	(389,'HASYA KHALISHA LASHIRA','24.22.24.307','TK','B','72a7ba96171fd543ced7'),
	(390,'MAYA SYIFA NUR&quot;AINI','24.22.24.308','TK','B','6f9b1c22eb2f884ddd6b'),
	(391,'MECCA ARETHA RAHMAN ','24.22.24.309','TK','B','d973dcd03fbb4262fe7f'),
	(392,'RADEA WIRASENA ARSY','24.22.24.311','TK','B','2b41968417db267298ed'),
	(393,'RAFIANDI ZUHAYR NAUFAL SIDDIQ','24.22.24.312','TK','B','556f9b0394b4799b13c4'),
	(394,'RYUGA DANEER ERLEN','24.22.24.313','TK','B','1e07b928d29932b749be'),
	(395,'SENANDUNG HUSNA GANTARI SETIAWAN','24.22.24.315','TK','B','81916fc7a3e7ed7272ea'),
	(396,'SHAE ZAHSY HANANIA','24.22.24.316','TK','B','e6b1f00b539b9d6ce8ce'),
	(397,'TANISHA INDANA SAKHI','24.22.24.317','TK','B','4be4b9e089c7773fa9b3'),
	(398,'NAJWA AULIYA AHMAD','24.22.24.343','TK','B','598c2abd8453965a5c40'),
	(399,'ABYAZ ZAYN KUSUMA','24.22.24.318','TK','B','29f786a7a79ab9cd2c43'),
	(400,'AISHA RAIHANA HERYANTO','24.22.24.319','TK','B','fc273bb6adcbb65dd184'),
	(401,'DINDA MARYAM NURGHAISANI','24.22.24.321','TK','B','8c852d8346dd8bff4b4d'),
	(402,'ELZAIDAN RAID ALHABSYI','24.22.24.322','TK','B','10541fd445ff1519dbe4'),
	(403,'MIKHAIL JUNAULIAN AVANINDRA','24.22.24.326','TK','B','9de8568c53267db86bbc'),
	(404,'QIANA AJENG CAHYANI','24.22.24.328','TK','B','2e053cc5dc3347641122'),
	(405,'RAZQA ZHAFRAN HAMDANI','24.22.24.330','TK','B','9c9378868871c6a35949'),
	(406,'GHAISANI ASMA KARUNIA','25.11.24.032','TK','B','319ecd10796868f774cd'),
	(407,'MUHAMMAD ARSYA FAUZAN','25.11.24.033','TK','B','302f1dde994817fad782'),
	(408,'MUHAMMAD EL HAQ JAYADIPA','25.11.24.034','TK','B','2d24bc9c6e010eba6188'),
	(409,'NADIRA HASNA&amp;amp;#039;A CARISSA','25.11.24.035','TK','B','65880d9305ecb52fd7a1'),
	(410,'NAYLA SYAFIRA NURFADHILLAH','25.11.24.036','TK','B','1299faed04bde6d133aa'),
	(411,'RAFFASYA ZEHAN FAEYZA','25.11.24.037','TK','B','490687b20bb346293663'),
	(412,'RAKANA MAHESWARI BIA','25.11.24.038','KB','1','3b7b541109b6caacb3c1'),
	(413,'KAURREN','25.11.24.039','KB','1','ed7689fdb58279f9444a'),
	(414,'KENZIE ADHIYOPA RAIN','25.11.24.040','TK','A','9ffea41134d47068bcc4'),
	(415,'MUHAMMAD EILSHAN NUGRAHA','25.11.24.041','TK','A','3f0226dcbe0156bf12f7'),
	(416,'PRABU RAFAEYZA ARKA PUTRA','25.11.24.042','TK','A','33a33f07a2bd1748bc20'),
	(417,'FADLAN','25.11.24.043','TK','B','772a29033e273e78e9cc');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tb_siswa2526`;

CREATE TABLE IF NOT EXISTS `tb_siswa2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `kelamin` varchar(20) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(20) NOT NULL,
  `ortu` varchar(75) DEFAULT NULL,
  `alamat` text DEFAULT NULL,
  `tang_A` varchar(10) NOT NULL,
  `tang_B` varchar(10) NOT NULL,
  `tang_C` varchar(10) NOT NULL,
  `tang_D` varchar(10) NOT NULL,
  `tang_E` varchar(10) NOT NULL,
  `tang_F` varchar(10) NOT NULL,
  `tang_G` varchar(10) NOT NULL,
  `tang_H` varchar(10) NOT NULL,
  `tang_I` varchar(10) NOT NULL,
  `tang_J` varchar(10) NOT NULL,
  `tang_K` varchar(10) NOT NULL,
  `tang_L` varchar(10) NOT NULL,
  `tang_M` varchar(10) NOT NULL,
  `tang_N` varchar(10) NOT NULL,
  `tang_O` varchar(10) NOT NULL,
  `tang_P` varchar(10) NOT NULL,
  `tang_Q` varchar(10) NOT NULL,
  `tang_R` varchar(10) NOT NULL,
  `tang_S` varchar(10) NOT NULL,
  `tang_T` varchar(10) NOT NULL,
  `tang_U` varchar(10) NOT NULL,
  `tang_V` varchar(10) NOT NULL,
  `tang_W` varchar(10) NOT NULL,
  `tang_X` varchar(10) NOT NULL,
  `tang_Y` varchar(10) NOT NULL,
  `tang_Z` varchar(10) NOT NULL,
  `status` varchar(15) NOT NULL,
  `email` varchar(75) NOT NULL,
  `hp` varchar(15) NOT NULL,
  `kategori` varchar(200) NOT NULL,
  `startAt` varchar(2) NOT NULL,
  `catatan` text DEFAULT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=418 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_siswa2526` (`no`, `nama`, `nis`, `kelamin`, `jenjang`, `paralel`, `ortu`, `alamat`, `tang_A`, `tang_B`, `tang_C`, `tang_D`, `tang_E`, `tang_F`, `tang_G`, `tang_H`, `tang_I`, `tang_J`, `tang_K`, `tang_L`, `tang_M`, `tang_N`, `tang_O`, `tang_P`, `tang_Q`, `tang_R`, `tang_S`, `tang_T`, `tang_U`, `tang_V`, `tang_W`, `tang_X`, `tang_Y`, `tang_Z`, `status`, `email`, `hp`, `kategori`, `startAt`, `catatan`, `id`) VALUES
	(347,'ZAHRA SHABIRA HAMDANI','24.11.24.312','P','KB','1','','Dusun Lampegan RT.028 RW.011 Simpar Cipunagara','','4440000','4750000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0823 2047 2910','UMUM','1','','af19fb42dd4995673cd1'),
	(348,'AGAM AHMAD AL RUBY','24.11.24.303','L','KB','1','','Puri Subang Asri Blok A No.1  Subang','','4440000','4750000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821 2771 0711','UMUM','1','','6f81e2aebcabb3e2dd96'),
	(349,'ALZIO SYAFIQ','25.11.24.001','L','KB','1','','Jl. Ampera Dusun 2 RT.12 RW.05 Desa Belendung Kec. Cibogo 41285','','4440000','5050000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','520a815e2f2930a92b1d'),
	(350,'APRIZIO ADZKAR RAZEL','25.11.24.002','L','KB','1','','Jl. Otista Gg. Mawar No.14 RT.51 Rw. 13 Kel. Karang Anyar Kec. Subang 41211','','4440000','5600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','b3bd5d0e3d2a23601149'),
	(351,'AQILA SHAFA NADINE','25.11.24.003','P','KB','1','','jJl. RA Kartini NO. 21 RT. 026 RW.010 Kel. Soklat Kec. Subang 41215','','4440000','5050000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','0cba2e5a1ab4fe0a3464'),
	(352,'AZALEA QALESYA ZALINDRA','25.11.24.004','P','KB','1','','Prima Talaga Sunda Jl. Talaga Raya No. 36 RT.68 RW 22 Kel. Dangdeur Kec. Subang','','4070000','5600000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','9d27ad16d273ee43abdf'),
	(353,'EMIL ARSENIO FATCHURAHMAN','25.11.24.005','L','KB','1','','Dusun Sidamukti RT.06 RW.02 Kel. Blendung Kec. Purwadadi 41261','','4440000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ce266cbd0dfc360b84e0'),
	(354,'IMARA PRADITA GANTARI','25.11.24.006','P','KB','1','','Perumahan Subang Green City B1/22 RT.26 RW.08 Kel. Cinangsi Kec. Cibogo 41285','','4440000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','2759a808617adb0a8fcf'),
	(355,'JA&amp;#039;FAR SHODIQ ALI','25.11.24.007','L','KB','1','','Perumahan Kelapa Residen Blok E 5 RT. 58 RW. 05 Kel. Dangdeur Kec. Subang','','4070000','5350000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','3ba13deb3f922c2e0c13'),
	(356,'MALAYKA NUR ADEEVA ABDURRAHMAN','25.11.24.008','P','KB','1','','','','4440000','4800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','5433653c10f3bb6450d4'),
	(357,'RAYYAN ALTAIR PRATAMA','25.11.24.009','L','KB','1','','Kp. Dampit RT.16 RW.09 Kel. Cijambe Kec. Cijambe Subang','','4440000','5050000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','67b4c5e9ef040590a04b'),
	(358,'QHAIRA ADARA NUR PUTRI REFIANDI','25.11.24.010','P','KB','1','','Surya Cigadung Blok C No.45 Kel. Cigadung Kec. Subang','','4440000','5050000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','b9d64e8c684295bedc27'),
	(359,'GAFFI ATHALLA DZIKRI','25.11.24.011','L','KB','1','','Perumahan Pesona Permata Hijau Blok B88 Pasirkareumbi Subang','','4440000','5350000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','645b62279fe1c80f4723'),
	(360,'ALYA AZZAHRA ALFATHUNNISA','24.11.24.290','P','TK','A','','Kp. Sukahurip RT.007 RW.003 DS Cisaga Kec. Cibogo Kab. Subang','','2520000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0853 5109 3888','UMUM','1','','69e07a9b7900c8b52143'),
	(361,'ASHRAF DZAMAAR RAFISQY SIDDIQ','24.11.24.292','L','TK','A','','Jl. Brigjen Katamso No.4 Subang','','4620000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','2813a7ff658bb140bfac'),
	(362,'ATHAYYA DZAKA AFANDHI KUSNANTO','24.11.24.293','L','TK','A','','Grand Subang Residence Blok D2 No.32','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','0aee28288b48f57698bb'),
	(363,'SHAQILA NESYA AR-RASYID','24.11.24.301','P','TK','A','','Grand Subang Residence','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','cd2f30f1fcbf9c5df345'),
	(364,'ZARA ARRAWFA NAYANIKA','24.11.24.302','P','TK','A','','Jl. Jambu Raya No.33 Blok 5','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','7cb9320b308d51d341bc'),
	(365,'CHAIRA KHALIFANI YAHYA','24.11.24.304','P','TK','A','','Perum Graha Subang Kencana 1 Blok D21','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','e48f4289865646527bb2'),
	(366,'KALANDRA ABRISAM IBRAHIM','24.11.24.307','L','TK','A','','Subang Green City E6/9','','5040000','5000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','43be73362b1f36811376'),
	(367,'SYAHNAZ MAFAZA ADLILLAH POHAN','24.11.23.276','P','TK','A','','Jl. Darmodiharjo 38/12 Kel. Sukamelang','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','8e6dbb4a7eeb5c6b089c'),
	(368,'VELICA KIERAN SLAMET GHUMAISHA','24.11.23.277','P','TK','A','','Jl. Brigjen Katamso No. 4 RT: 24 RW: 13 Kel. Dangdeur','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','072bff9a946b07beba75'),
	(369,'ABYAN ALIF FIRDAUS','25.11.24.012','L','TK','A','','Kp. Sembung 1 Gunung Sembung Pagaden','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','754c6bc75334f6f591e1'),
	(370,'ANDINY LAQUITTA PUTRIWIBOWO','25.11.24.013','P','TK','A','','Green Panji Permata Land No. 133 RT. 097 RW. 011 Kel. Cigadung Kec. Subang','','5040000','5800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','765fc13eb7caf0ab7187'),
	(371,'DARREN ACHAZIA RINALDI','25.11.24.014','L','TK','A','','Jl. Letnan Ukin Blok Sukasari RT.017 RW.005 KEL. Soklat Kec Subang 41211','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','c9be0521a2e649305cb6'),
	(372,'DIAN AZKA UTAMI','25.11.24.015','P','TK','A','','Jl. Otista Gg. Bima RT.29 RW.009 Kel. Sukamelang Kec. Subang','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','c9b823ad9d59a134b10f'),
	(373,'EL FATIH ATHARIZ PRATAMA','25.11.24.016','L','TK','A','','Jl. Mayjen Sutoyo Gg.Pisang RT.059 RW.016 Kel. Karang Anyar Kec.Subang 41211','','5040000','5750000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','343ce59983b851aef213'),
	(374,'FATHIR SHIDQI DHIAULHAQ','25.11.24.017','L','TK','A','','','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','3dca4bac94e5ab43b8e3'),
	(375,'HAFIZH ZHAFRAN RAMDHANI','25.11.24.018','L','TK','A','','','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','449400c39a3a48917049'),
	(376,'HABIBIE MUSTHAFA RAMADHAN','25.11.24.019','L','TK','A','','Perumahan Mahkota Graha Blok Aglonema B17/37 RT 018/058 Desa Cibarola Kec.Soklat','','5040000','6900000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','a205b5ae0d655261631a'),
	(377,'HELENA BRIGZYA SAUSA PRABOWO','25.11.24.020','P','TK','A','','Pogung Dalangan RT.08 RW. 50 NO.15B Kel. Sinduadi Kec. Mlati Kab. Sleman','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','026f52ea217cd97fd519'),
	(378,'KANAYAA MAULIDYA SUDARMAN ','25.11.24.021','P','TK','A','','Kp.Handiwung RT.27 RW.09 Kel. Gembor Kec. Pagaden 41251','0','5040000','5750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','','UMUM','1','','619a9bf730f8f4044eaf'),
	(379,'KHAIRIN NISAK HANAFIAH','25.11.24.022','P','TK','A','','Asrama Yonif 312 Kala Hitam RT. 040 Rw. 016 Kel. Dangdeur Kec Subang ','','5040000','5750000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','4073ea1ae587174f474b'),
	(380,'MUHAMMAD NUR ALDIZAR SUYANTO','25.11.24.023','L','TK','B','','BTN Ciheuleut B.13 NO. 262 ','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','daa7123471eee8d8cce5'),
	(381,'MUHAMMAD RAYYANDRA ZULFIKAR AL FATIH','25.11.24.025','L','TK','A','','Jl. RA Kartini RT. 022 RW. 008 Perum BSR Blok E4 No.14 Kel. Wanareja Kec. Subang','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','1740d7b08afec57b8451'),
	(382,'MUHAMMAD ZEESHAN PERBAWA','25.11.24.026','L','TK','A','','KP. Maja Asih RT.011 RW.004 Kel. Majasari Kec. Cibogo Subang','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','856b6bdd942bd33c9604'),
	(383,'NAHDA FAIHA SIREGAR','25.11.24.028','P','TK','A','','Green City Blok B1 No 43 RT. 026 RW. 008 Desa Cinangsih Kec. Cibogo Subang 41285','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','fcdbf88ae7ea872f3309'),
	(384,'NAURA RASHA AZKIYA','25.11.24.029','P','TK','A','','Jl. Tanjung Wangi No.16','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','1c122e9131e53369c527'),
	(385,'NAUSHAD WALDAN KURNIAWAN','25.11.24.030','L','TK','A','','Jl. Apel Raya No.3 Perumnas RT.75 RW.21 Kel. Karanganyar Kec. Subang 41211','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','c0626726fdba6ff2665e'),
	(386,'HAYKAL NEVAN ABHISEVA','25.11.24.031','L','TK','A','','Jl. Lobak Blok E No.2 Puri Subang Asri Kel. Sukamelang Ke. Subang','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','019afe34baf2a625af95'),
	(387,'AFIYA NASYITA MUNANDAR','24.22.24.304','P','TK','B','','Kmp babakan Curug Cijambe','0','4620000','5000000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0812 8297 3667','UMUM','1','','44ebd3b586d8a312f912'),
	(388,'HAFY RASYID ADSKHAN','24.22.24.306','L','TK','B','','Kp. Jambeanom RT: 08 RW: 02 DS. Purwadadi Barat','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','085216330370','UMUM','1','','55c446145f35eb9e3b65'),
	(389,'HASYA KHALISHA LASHIRA','24.22.24.307','P','TK','B','','Perum Pesona Alam Cisugih Blok Dahlia D.11 No.19','0','4620000','5500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0822 2199 9876','UMUM','1','','72a7ba96171fd543ced7'),
	(390,'MAYA SYIFA NUR&quot;AINI','24.22.24.308','P','TK','B','','Perum SGC Blok B.6 No.23','0','4620000','5500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0838 6161 5273','UMUM','1','','6f9b1c22eb2f884ddd6b'),
	(391,'MECCA ARETHA RAHMAN ','24.22.24.309','P','TK','B','','Bumi Abdi Praja Kavling no 08','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0878 2551 5169','UMUM','1','','d973dcd03fbb4262fe7f'),
	(392,'RADEA WIRASENA ARSY','24.22.24.311','L','TK','B','','Kp. Situraja Cinangsi Cibogo','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0852 2220 0157','UMUM','1','','2b41968417db267298ed'),
	(393,'RAFIANDI ZUHAYR NAUFAL SIDDIQ','24.22.24.312','L','TK','B','','Jl. Brigjen Katamso No.4 Subang','0','4620000','5500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0813 2056 3214','UMUM','1','','556f9b0394b4799b13c4'),
	(394,'RYUGA DANEER ERLEN','24.22.24.313','L','TK','B','','Komp. Buana Subang Raya Block C8 No. 9','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0813 2045 4546','UMUM','1','','1e07b928d29932b749be'),
	(395,'SENANDUNG HUSNA GANTARI SETIAWAN','24.22.24.315','P','TK','B','','Perum Puri Subang Asri Blok T-9 Kel. Sukamelang','0','5040000','5000000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0856 2064 634','UMUM','1','','81916fc7a3e7ed7272ea'),
	(396,'SHAE ZAHSY HANANIA','24.22.24.316','P','TK','B','','Kp. Bantar Sema RT: 19 / RW: 02 DS. Cisaga - Cibogo','0','4620000','5500000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0821 1199 7789','UMUM','1','','e6b1f00b539b9d6ce8ce'),
	(397,'TANISHA INDANA SAKHI','24.22.24.317','P','TK','B','','Perumahan Pesona Alam Cisugih Blok D.6 No.4','','2520000','2750000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0822 1884 7778','UMUM','1','','4be4b9e089c7773fa9b3'),
	(398,'NAJWA AULIYA AHMAD','24.22.24.343','P','TK','B','','Jln. Marsinu No.08 Dangdeur Subang','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821 3096 3291','UMUM','1','','598c2abd8453965a5c40'),
	(399,'ABYAZ ZAYN KUSUMA','24.22.24.318','L','TK','B','','Perum Surya Cigadung Jl. Asturnus E/72','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821 3065 3644','UMUM','1','','29f786a7a79ab9cd2c43'),
	(400,'AISHA RAIHANA HERYANTO','24.22.24.319','P','TK','B','','Rekamaya RT:28 / RW: 9 Sukamelang','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0853 1693 3321','UMUM','1','','fc273bb6adcbb65dd184'),
	(401,'DINDA MARYAM NURGHAISANI','24.22.24.321','P','TK','B','','BTN Ciheuleut Indah Blok A6 No.76','','4620000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0859 5635 2607','UMUM','1','','8c852d8346dd8bff4b4d'),
	(402,'ELZAIDAN RAID ALHABSYI','24.22.24.322','L','TK','B','','Jln. Anggur VII No.13 Blok 4 Perumnas Subang','','4620000','5000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821 1524 1722','UMUM','1','','10541fd445ff1519dbe4'),
	(403,'MIKHAIL JUNAULIAN AVANINDRA','24.22.24.326','L','TK','B','','RSS Sidodadi Blok D Subang','','4620000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0811 2290 168','UMUM','1','','9de8568c53267db86bbc'),
	(404,'QIANA AJENG CAHYANI','24.22.24.328','P','TK','B','','Perum pesona Permata Hijau','','4620000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0853 2157 5978','UMUM','1','','2e053cc5dc3347641122'),
	(405,'RAZQA ZHAFRAN HAMDANI','24.22.24.330','L','TK','B','','Dusun Lampegan RT.028 RW.011 Simpar Cipunagara','','5040000','5500000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0823 2047 2910','UMUM','1','','9c9378868871c6a35949'),
	(406,'GHAISANI ASMA KARUNIA','25.11.24.032','P','TK','B','','Jl. Apel Raya No.3 Perumnas RT.75 RW.21 Kel. Karanganyar Kec. Subang 41211','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0852 2091 2209 ','UMUM','1','','319ecd10796868f774cd'),
	(407,'MUHAMMAD ARSYA FAUZAN','25.11.24.033','L','TK','B','','','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0812 8009 6087 ','UMUM','1','','302f1dde994817fad782'),
	(408,'MUHAMMAD EL HAQ JAYADIPA','25.11.24.034','L','TK','B','','BBK Bandung RT. 032 RW. 011 Kel. Sukamelang Kec. Subang 41251','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821 3013 6275','UMUM','1','','2d24bc9c6e010eba6188'),
	(409,'NADIRA HASNA&amp;amp;#039;A CARISSA','25.11.24.035','P','TK','B','','Sukamelang RT.029 RW. 009 Kel. Sukamelang Kec. Subang ','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0821 1787 9988','UMUM','1','','65880d9305ecb52fd7a1'),
	(410,'NAYLA SYAFIRA NURFADHILLAH','25.11.24.036','P','TK','B','','Dusun Belendung RT.011 RW.004 Kec. Cibogo Kab. Subang','0','5040000','5750000','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','Aktif','','0821 2895 1020','UMUM','1','','1299faed04bde6d133aa'),
	(411,'RAFFASYA ZEHAN FAEYZA','25.11.24.037','L','TK','B','','Kp Cileutik RT.02 RW.01 Kel. Situsari Kec. Dawuan Subang','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','0822 4079 5567 ','UMUM','1','','490687b20bb346293663'),
	(412,'RAKANA MAHESWARI BIA','25.11.24.038','L','KB','1','','','','4440000','5650000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','3b7b541109b6caacb3c1'),
	(413,'KAURREN','25.11.24.039','p','KB','1','','','','4440000','','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','ed7689fdb58279f9444a'),
	(414,'KENZIE ADHIYOPA RAIN','25.11.24.040','L','TK','A','','','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','9ffea41134d47068bcc4'),
	(415,'MUHAMMAD EILSHAN NUGRAHA','25.11.24.041','L','TK','A','','','','4620000','5800000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','3f0226dcbe0156bf12f7'),
	(416,'PRABU RAFAEYZA ARKA PUTRA','25.11.24.042','L','TK','A','','','','5040000','6300000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','33a33f07a2bd1748bc20'),
	(417,'FADLAN','25.11.24.043','L','TK','B','','','','5040000','6000000','','','','','','','','','','','','','','','','','','','','','','','','Aktif','','','UMUM','1','','772a29033e273e78e9cc');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list2526`;

CREATE TABLE IF NOT EXISTS `payment_list2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(120) NOT NULL,
  `jenjang` varchar(10) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `hp` varchar(18) NOT NULL,
  `email` varchar(100) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `keterangan` text DEFAULT NULL,
  `payment_id` varchar(50) NOT NULL,
  `tahun` varchar(9) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_list_detail2526`;

CREATE TABLE IF NOT EXISTS `payment_list_detail2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `payment_id` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `payment_set`;

CREATE TABLE IF NOT EXISTS `payment_set` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `aktif` varchar(1) DEFAULT NULL,
  `sistem` varchar(2) NOT NULL,
  `api` text DEFAULT NULL,
  `callback` text DEFAULT NULL,
  `fee` varchar(15) NOT NULL,
  `id` text NOT NULL,
  PRIMARY KEY (`no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `payment_set` (`no`, `aktif`, `sistem`, `api`, `callback`, `fee`, `id`) VALUES
	(1,'','','','','0','8E73735D50169571C0680DDA603E6BC4');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_siswa2526`;

CREATE TABLE IF NOT EXISTS `tabungan_siswa2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(100) NOT NULL,
  `nis` varchar(18) NOT NULL,
  `rekening` varchar(20) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `saldo` varchar(15) NOT NULL,
  `status` varchar(15) NOT NULL,
  `id` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_by` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

DROP TABLE IF EXISTS `db_transaksi2526`;

CREATE TABLE IF NOT EXISTS `db_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` datetime NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `kelamin` varchar(2) NOT NULL,
  `jenjang` varchar(5) NOT NULL,
  `paralel` varchar(50) NOT NULL,
  `kategori` varchar(30) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `tahap` float NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `random` varchar(20) NOT NULL,
  `penerima` varchar(100) NOT NULL,
  `setor` varchar(10) NOT NULL,
  `id_setor` varchar(50) NOT NULL,
  `metode` varchar(20) NOT NULL,
  `catatan` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `ip` varchar(30) NOT NULL,
  `browser` text DEFAULT NULL,
  `id_tr` varchar(50) NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=226 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `db_transaksi2526` (`no`, `tanggal`, `nis`, `nama`, `kelamin`, `jenjang`, `paralel`, `kategori`, `jenis`, `tahap`, `jumlah`, `random`, `penerima`, `setor`, `id_setor`, `metode`, `catatan`, `time`, `ip`, `browser`, `id_tr`, `id`) VALUES
	(2,'2025-02-11 00:00:00','25.11.24.004','AZALEA QALESYA ZALINDRA','P','KB','1','UMUM','C',1,'5600000','793976RONW11','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB57','5AD55892SAMCEAJ73FE1'),
	(3,'2025-02-17 00:00:00','25.11.24.003','AQILA SHAFA NADINE','P','KB','1','UMUM','C',1,'3000000','793976RONW12','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB58','5AD55892SAMCEAJ73FE2'),
	(5,'2025-03-06 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','C',1,'1250000','793976RONW14','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB60','5AD55892SAMCEAJ73FE4'),
	(1,'2025-01-21 00:00:00','25.11.24.015','DIAN AZKA UTAMI','P','TK','A','UMUM','C',1,'2800000','793976RONW1D','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB56','5AD55892SAMCEAJ73FE0'),
	(4,'2025-02-26 00:00:00','24.11.23.277','VELICA KIERAN SLAMET GHUMAISHA','P','TK','A','UMUM','C',1,'1000000','793976RONW13','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB59','5AD55892SAMCEAJ73FE3'),
	(6,'2025-03-18 00:00:00','25.11.24.006','IMARA PRADITA GANTARI','P','KB','1','UMUM','C',1,'4800000','793976RONW15','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB61','5AD55892SAMCEAJ73FE5'),
	(7,'2025-03-18 00:00:00','24.11.24.307','KALANDRA ABRISAM IBRAHIM','L','TK','A','UMUM','C',1,'1000000','793976RONW16','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB62','5AD55892SAMCEAJ73FE6'),
	(8,'2025-03-18 00:00:00','25.11.24.016','EL FATIH ATHARIZ PRATAMA','L','TK','A','UMUM','C',1,'1650000','793976RONW17','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB63','5AD55892SAMCEAJ73FE7'),
	(9,'2025-03-24 00:00:00','24.11.23.277','VELICA KIERAN SLAMET GHUMAISHA','P','TK','A','UMUM','C',2,'1000000','793976RONW18','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB64','5AD55892SAMCEAJ73FE8'),
	(10,'2025-03-26 00:00:00','24.22.24.309','MECCA ARETHA RAHMAN ','P','TK','B','UMUM','C',1,'500000','793976RONW19','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB65','5AD55892SAMCEAJ73FE9'),
	(11,'2025-04-17 00:00:00','25.11.24.002','APRIZIO ADZKAR RAZEL','L','KB','1','UMUM','C',1,'5600000','793976RONW20','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB66','5AD55892SAMCEAJ73FE10'),
	(12,'2025-04-24 00:00:00','24.11.23.277','VELICA KIERAN SLAMET GHUMAISHA','P','TK','A','UMUM','C',3,'1000000','793976RONW21','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB67','5AD55892SAMCEAJ73FE11'),
	(13,'2025-04-27 00:00:00','24.22.24.308','MAYA SYIFA NUR\'AINI','P','TK','B','UMUM','C',1,'5500000','793976RONW22','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB68','5AD55892SAMCEAJ73FE12'),
	(14,'2025-05-05 00:00:00','25.11.24.031','HAYKAL NEVAN ABHISEVA','L','TK','A','UMUM','C',1,'6000000','793976RONW23','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB69','5AD55892SAMCEAJ73FE13'),
	(15,'2025-05-05 00:00:00','24.11.24.307','KALANDRA ABRISAM IBRAHIM','L','TK','A','UMUM','C',2,'1000000','793976RONW24','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB70','5AD55892SAMCEAJ73FE14'),
	(16,'2025-05-06 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','C',2,'3750000','793976RONW25','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB71','5AD55892SAMCEAJ73FE15'),
	(17,'2025-05-09 00:00:00','24.11.24.307','KALANDRA ABRISAM IBRAHIM','L','TK','A','UMUM','C',3,'3000000','793976RONW26','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB72','5AD55892SAMCEAJ73FE16'),
	(18,'2025-05-14 00:00:00','25.11.24.037','RAFFASYA ZEHAN FAEYZA','P','TK','B','UMUM','C',1,'2500000','793976RONW27','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB73','5AD55892SAMCEAJ73FE17'),
	(19,'2025-05-16 00:00:00','25.11.24.007','JA\'FAR SHODIQ ALI','L','KB','1','UMUM','C',1,'5350000','793976RONW28','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB74','5AD55892SAMCEAJ73FE18'),
	(20,'2025-05-16 00:00:00','25.11.24.028','NAHDA FAIHA SIREGAR','P','TK','A','UMUM','C',1,'3350000','793976RONW29','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB75','5AD55892SAMCEAJ73FE19'),
	(21,'2025-05-19 00:00:00','25.11.24.022','KHAIRIN NISAK HANAFIAH','P','TK','A','UMUM','C',1,'1500000','793976RONW30','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB76','5AD55892SAMCEAJ73FE20'),
	(22,'2025-05-19 00:00:00','24.11.23.277','VELICA KIERAN SLAMET GHUMAISHA','P','TK','A','UMUM','C',4,'1000000','793976RONW31','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB77','5AD55892SAMCEAJ73FE21'),
	(23,'2025-05-20 00:00:00','25.11.24.020','HELENA BRIGZYA SAUSA PRABOWO','P','TK','A','UMUM','C',1,'2900000','793976RONW32','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB78','5AD55892SAMCEAJ73FE22'),
	(24,'2025-05-28 00:00:00','24.22.24.316','SHAE ZHASY HANANIA','P','TK','B','UMUM','C',1,'5500000','793976RONW33','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB79','5AD55892SAMCEAJ73FE23'),
	(25,'2025-06-02 00:00:00','25.11.24.015','DIAN AZKA UTAMI','P','TK','A','UMUM','C',2,'3200000','793976RONW34','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB80','5AD55892SAMCEAJ73FE24'),
	(26,'2025-06-04 00:00:00','24.11.24.312','ZAHRA SHABIRA HAMDANI','P','KB','1','UMUM','C',1,'4750000','793976RONW35','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB81','5AD55892SAMCEAJ73FE25'),
	(27,'2025-06-10 00:00:00','24.22.24.315','SENANDUNG HUSNA GANTARI SETIAWAN','P','TK','B','UMUM','C',1,'500000','793976RONW36','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB82','5AD55892SAMCEAJ73FE26'),
	(28,'2025-06-16 00:00:00','24.11.23.276','SYAHNAZ MAFAZA ADLILLAH POHAN','P','TK','A','UMUM','C',1,'2250000','793976RONW37','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB83','5AD55892SAMCEAJ73FE27'),
	(29,'2025-06-16 00:00:00','25.11.24.035','NADIRA HASNA\'A CARISSA','P','TK','B','UMUM','C',1,'6300000','793976RONW38','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB84','5AD55892SAMCEAJ73FE28'),
	(30,'2025-06-18 00:00:00','25.11.24.029','NAURA RASHA AZKIYA','P','TK','A','UMUM','C',1,'6300000','793976RONW39','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB85','5AD55892SAMCEAJ73FE29'),
	(31,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','C',1,'1000000','793976RONW40','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB86','5AD55892SAMCEAJ73FE30'),
	(32,'2025-06-20 00:00:00','24.22.24.311','RADEA WIRASENA ARSY','P','TK','B','UMUM','C',1,'5500000','793976RONW41','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB87','5AD55892SAMCEAJ73FE31'),
	(33,'2025-06-24 00:00:00','25.11.24.010','QHAIRA ADARA NUR PUTRI REFIANDI','P','KB','1','UMUM','C',1,'1850000','793976RONW42','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB88','5AD55892SAMCEAJ73FE32'),
	(34,'2025-06-24 00:00:00','25.11.24.019','HABIBIE MUSTHAFA RAMADHAN','L','TK','A','UMUM','C',1,'6900000','793976RONW43','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB89','5AD55892SAMCEAJ73FE33'),
	(35,'2025-06-24 00:00:00','25.11.24.028','NAHDA FAIHA SIREGAR','P','TK','A','UMUM','C',2,'2650000','793976RONW44','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB90','5AD55892SAMCEAJ73FE34'),
	(36,'2025-06-25 00:00:00','24.11.24.301','SHAQILA NESYA AR-RASYID','P','TK','A','UMUM','C',1,'1000000','793976RONW45','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-10 10:13:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','151FDF23ADCB91','5AD55892SAMCEAJ73FE35'),
	(38,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',1,'370000','07756ZYB717B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','2CAC60331CI9GDK29C36'),
	(39,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',2,'370000','07756ZQXZKB3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','08DC865791N9BKU73E51'),
	(40,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',3,'370000','077568JQI2E9','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','4905C5A21QZYE52726BD'),
	(41,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',4,'370000','07756O2IBWAA','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','6B37054FXDMGSXH4BF29'),
	(42,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',5,'370000','077562XEJY30','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','B4E9F07B69DSNCQ9D75E'),
	(43,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',6,'370000','077569BXJXF2','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','9B7E7DCAZRGHG2IBAB14'),
	(44,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',7,'370000','07756T8VDVCC','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','A9E383C96QDDI1Y5DAD0'),
	(45,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',8,'370000','5B48AACWIO02','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:26','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','0CB7158C08E8YGZ6D020'),
	(46,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',9,'370000','5B48AGTXQY7F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:26','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','281B8505SNLVLI5B0EF1'),
	(47,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',10,'370000','5B48AYOCD85B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:26','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','B4E8BDBCYBJKZZMC46DC'),
	(48,'2025-05-16 00:00:00','25.11.24.007','JA&amp;#039;FAR SHODIQ ALI','L','KB','1','UMUM','B',11,'370000','5B48AIULGSB9','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:14:26','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7F4F303DEBAA41','839CF654ZSYT34Y741E3'),
	(49,'2025-06-04 00:00:00','24.11.24.312','ZAHRA SHABIRA HAMDANI','P','KB','1','UMUM','B',1,'370000','35638GZLPXE0','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:16:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','90C03CFB420BA6','A11AFABAZGJV7D70BC56'),
	(50,'2025-06-04 00:00:00','24.11.24.312','ZAHRA SHABIRA HAMDANI','P','KB','1','UMUM','B',2,'370000','35638EW19F37','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:16:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','90C03CFB420BA6','ED8EDD58UDRGOLU1A719'),
	(51,'2025-06-04 00:00:00','24.11.24.312','ZAHRA SHABIRA HAMDANI','P','KB','1','UMUM','B',3,'370000','35638THZT08E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 16:16:15','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','90C03CFB420BA6','96C5D1C8MK1PAQ82C431'),
	(52,'2025-07-07 00:00:00','25.11.24.015','DIAN AZKA UTAMI','P','TK','A','UMUM','B',1,'420000','0C419K6D9S68','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:33:02','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C89CA523ADCC71','0F74D5A45GJEJR0ABC2F'),
	(53,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',1,'420000','20494LCQPC6C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','59F8A3B3B7AJ18905150'),
	(54,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',2,'420000','20494PP0VKF2','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','0AD3DFB9Y120LPM26ED3'),
	(55,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',3,'420000','20494JUSEH5C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','DE18817FMQO1RNUA2702'),
	(56,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',4,'420000','20494OH0KQB7','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','3840A3C0EWF5MEF4CEB7'),
	(57,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',5,'420000','20494PXRACDB','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','FF58E680IKBE1I8653F3'),
	(58,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',6,'420000','20494CBWTD70','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','7F84679DDH9VTV75C563'),
	(59,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',7,'420000','204942UPH649','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','9585176EDMBFKXTD3AB0'),
	(60,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',8,'420000','154E90DAVU14','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','21E1A0B8RKPQQQ6AE578'),
	(61,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',9,'420000','154E9MXECI54','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','800907338YS9MHI17EBB'),
	(62,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',10,'420000','154E9FO5Y974','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','BEE372AAI3C53PB67159'),
	(63,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','B',11,'420000','154E9G16EA21','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:35:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','65B05126DCDDA9','9C58B5E8A6U9UHRE8638'),
	(64,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',1,'420000','2B335977MVD4','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','604DD014548DOGE6C8EE'),
	(65,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',2,'420000','F40205US3688','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','009AC37EQ9JJVCV2B1DD'),
	(66,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',3,'420000','F4020ZYF151C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','0A09BCE7QMTPR6BFC90B'),
	(67,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',4,'420000','F4020O7PKE67','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','4B9EEC07780HXQLDB968'),
	(68,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',5,'420000','F40203ZAGRD2','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','5524625D7JW9CSUD19AE'),
	(69,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',6,'420000','F40200B4WV60','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','EF258AFA33FCRYEB9879'),
	(70,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',7,'420000','F40206S3KD1C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','1864D254XCXBE5R3602B'),
	(71,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',8,'420000','69D026W6ID01','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','850F720ENQIB7X3F5D89'),
	(72,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',9,'420000','69D02IPQOG52','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','69B31E6BOI89P2MFF998'),
	(73,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',10,'420000','69D02JRRHS65','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','006324F5CY6WEC21CCEF'),
	(74,'2025-06-18 00:00:00','24.22.24.328','QIANA AJENG CAHYANI','P','TK','B','UMUM','B',11,'420000','69D02FTCUKC6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:37:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59D3EB3CC57697','B5E81512YXZAYTD94EC0'),
	(75,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',1,'420000','FF3B8P5IS64E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','7A04846B32BGYPH78B6B'),
	(76,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',2,'420000','FF3B84CSOTF6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','3EE82C79BKQVJH74BBB5'),
	(77,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',3,'420000','FF3B8KHH3N2E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','71556B58D39FWAL1AEE2'),
	(78,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',4,'420000','FF3B804HV22E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','1093DA602YBKCJJF8C4C'),
	(79,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',5,'420000','FF3B8WZZDU9E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','148DCF40023PBIM26078'),
	(80,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',6,'420000','FF3B8JODHZF6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:35','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','CC5F75D6QSZS77P7E4A7'),
	(81,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',7,'420000','F9097G8B3C4C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','A6B191F1IZ69WX4A18D1'),
	(82,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',8,'420000','F90974M1U5DA','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','58937969W6ECX4D0FE18'),
	(83,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',9,'420000','F90976399B0F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','42C1BF55PRSI35X08839'),
	(84,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',10,'420000','F9097XUUQ93E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','5CDA1C4CLV9JOSU0441C'),
	(85,'2025-07-10 00:00:00','24.22.24.312','RAFIANDI ZUHAYR NAUFAL SIDDIQ','L','TK','B','UMUM','B',11,'420000','F9097LVVUR14','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:38:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C639209B037C77','00D93AC98NV2FPLF5BF1'),
	(86,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',1,'420000','90ECAYIOCO7E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','332BCAE8385JFJ98D9C6'),
	(87,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',2,'420000','90ECA6EGW443','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','6BFAC6D1LQW6TF76C239'),
	(88,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',3,'420000','90ECARYNT7AD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','0F1628A3YU15OOKC0770'),
	(89,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',4,'420000','90ECAXLWG14A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','A4A8A7EC7GO4F97FD82C'),
	(90,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',5,'420000','90ECA3DVXGD9','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','210A9F19Q0USI2R0704D'),
	(91,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',6,'420000','90ECAFZCTV08','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:17','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','7B1996A5FHASWL0CEC13'),
	(92,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',7,'420000','A727D7V6XR22','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:18','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','F5E30D69DC6NDG8CFADD'),
	(93,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',8,'420000','A727DPNORNA6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:18','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','C4000B7EE4SOQXL133A3'),
	(94,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',9,'420000','A727DM115E9C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:18','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','058002E2WY19Z2YBBA0A'),
	(95,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',10,'420000','A727DUB0OCAF','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:18','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','7BFE3F7APU2JWNZ31F73'),
	(96,'2025-07-14 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','B',11,'420000','A727DDR30785','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:43:18','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3D6AB71FD45CE0','0F121E8DLA6GAEB6198D'),
	(97,'2025-06-04 00:00:00','24.22.24.330','RAZQA ZHAFRAN HAMDANI','L','TK','B','UMUM','B',1,'420000','BF178VLFPWF4','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:45:21','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8D14F0788617E7','3B1336AEUS8PDJNE952E'),
	(98,'2025-06-04 00:00:00','24.22.24.330','RAZQA ZHAFRAN HAMDANI','L','TK','B','UMUM','B',2,'420000','BF178DUPEACC','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-14 17:45:21','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','8D14F0788617E7','613B982D6L3TDLJ54495'),
	(99,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',1,'420000','3999AQ1YEP0B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:44','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','0F181D868YYM2KQ863E8'),
	(100,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',2,'420000','3999A7MG0P68','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:44','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','E683BC79BMUISW6ADB66'),
	(101,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',3,'420000','3999A55V40A6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:44','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','24BCB933CRAX9XJ0E1B9'),
	(102,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',4,'420000','0C6F5NETFBB8','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','614DAB3B2KEOM3OE2A30'),
	(103,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',5,'420000','0C6F54KV9ED2','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','71402EC3WTX1LX115CFB'),
	(104,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',6,'420000','0C6F5129ZAC5','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','45C5463BRWGWCQQ0E538'),
	(105,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',7,'420000','0C6F5FD21C8F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','6E998C55UD73BKJ7366D'),
	(106,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',8,'420000','0C6F529O6M30','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','5EC2C13DYO8GR7RCFF08'),
	(107,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',9,'420000','0C6F5GI5M647','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:45','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','BC352A5968IVBRQ3D66C'),
	(108,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',10,'420000','BBCA54MJX1D7','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:46','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','93057F3CYZISF3TF41AC'),
	(109,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','B',11,'420000','BBCA5BM2CF21','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:46:46','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4F6F4D568C10BB','F2E40CF9EL179WEB7C8E'),
	(110,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',1,'420000','468EFJ7YWFA7','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','3E652635L6CNX9SEC756'),
	(111,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',2,'420000','468EF5Q2JVCB','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','B0461757HKD4BC9C4268'),
	(112,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',3,'420000','468EFY71GJ9E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','8E77C4C78PP7SJ16E357'),
	(113,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',4,'420000','468EF1TY246F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','3BAA9197C5BDNBQ19C33'),
	(114,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',5,'420000','AA362SRP5I88','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','3F8FE4EADXDHOZMBC177'),
	(115,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',6,'420000','AA362YZO5ADA','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','3A891C28M5MZR165A6B0'),
	(116,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',7,'420000','AA362IBY6TE4','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','06C4BB98I0LA4WJC0356'),
	(117,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',8,'420000','AA362SPTTAF2','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','53938548ZVPHABT0F047'),
	(118,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',9,'420000','AA362OSPF479','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','50AF9D8BVACZ75ZF050C'),
	(119,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',10,'420000','AA362T46KEC6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','5944905ESD9ARFN6E46F'),
	(120,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','B',11,'420000','0E237LMIVU6C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','Disc 1 bulan','2025-07-14 17:47:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','9AA8D62D83C2CE','2B8594123851EPT71A94'),
	(121,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',1,'420000','98FBFS0DT64F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','CC2FF1284XWNRZMF481C'),
	(122,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',2,'420000','98FBF36LGCAE','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','7BABFC36IMSHG7MD43DE'),
	(123,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',3,'420000','98FBFD1QFIED','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','64579BFC0MEKV7TD8F77'),
	(124,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',4,'420000','98FBFJ8TTJC3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','47D0F037YEM3HSB70639'),
	(125,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',5,'420000','AF5AB8KC6OF9','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','9FFA2597AG963F18A42A'),
	(126,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',6,'420000','AF5ABNDNAI7B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','80609ACDDWICMSRD01EF'),
	(127,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',7,'420000','AF5ABVBO7HDE','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','0E417572DTQKCNPD5C3E'),
	(128,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',8,'420000','AF5ABON6DHD3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','DBC316FCO56XDDZ1AF76'),
	(129,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',9,'420000','6D80AYTLD25E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','84911D0DQZQ3KL280002'),
	(130,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',10,'420000','6D80ANYPK9EF','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','2B104D39V6BR6YO6E746'),
	(131,'2025-07-10 00:00:00','24.11.24.292','ASHRAF DZAMAAR RAFISQY SIDDIQ','L','TK','A','UMUM','B',11,'420000','6D80AXTZ6G17','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 18:28:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D7FA79A7FFB895','CD704329RUPZ5KOD6547'),
	(132,'2025-07-07 00:00:00','24.11.24.302','ZARA ARRAWFA NAYANIKA','P','TK','A','UMUM','B',1,'420000','3D7838IP4M29','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:20:26','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C55534320B1C8F','326123281KP85SE1D86E'),
	(133,'2025-07-20 00:00:00','25.11.24.015','DIAN AZKA UTAMI','P','TK','A','UMUM','B',2,'420000','17F3AHMNKJ75','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:23:57','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D4D9DA23AD635A','8579E108VTDLBENE573C'),
	(134,'2025-07-20 00:00:00','25.11.24.015','DIAN AZKA UTAMI','P','TK','A','UMUM','B',3,'420000','17F3AKYJFV94','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:23:57','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D4D9DA23AD635A','8D7146B6Y83RXPB3A840'),
	(135,'2025-07-23 00:00:00','25.11.24.021','KANAYAA MAULIDYA SUDARMAN ','P','TK','A','UMUM','B',1,'420000','200B1IR58178','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:28:10','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','276AAA9BF70FA0','81A5BC96OKE2YX87B42F'),
	(136,'2025-07-14 00:00:00','25.11.24.030','NAUSHAD WALDAN KURNIAWAN','L','TK','A','UMUM','B',1,'420000','B9C93N39AF4D','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:32:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','56375C67262B58','FCC4765D5SGE4NTE7AB6'),
	(137,'2025-07-14 00:00:00','24.22.24.319','AISHA RAIHANA HERYANTO','P','TK','B','UMUM','B',1,'420000','A7DD059BXCF4','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:47:39','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','B5AC183BB6A241','C21DCC2326331O55DB37'),
	(138,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',1,'420000','62DB9A1BNV73','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','B70B5D31GXKP2O1629A5'),
	(139,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',2,'420000','62DB9N974C1A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','907018461I9LIBS3BAD4'),
	(140,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',3,'420000','62DB9FJ4VVE0','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','AB72DB24EIWOVCJD8EED'),
	(141,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',4,'420000','62DB9ON6AP46','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:54','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','155AE499R7YX3H29002B'),
	(142,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',5,'420000','C7545XW225B5','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','D84C647FNYQSETN66E58'),
	(143,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',6,'420000','C7545IOMJQ94','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','802746B9AAVVPVB45FB3'),
	(144,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',7,'420000','C7545X9N5UCD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','21EAD8004AX88X5CEA9A'),
	(145,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',8,'420000','C7545BEPYQ5E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','B158EAEA48Z9VVO89F61'),
	(146,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',9,'420000','03016TNX1LB3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','4675974EE9K718N8C5F7'),
	(147,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',10,'420000','03016K2AYJ81','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','F39B1AEBWYSCCY631E4F'),
	(148,'2025-07-14 00:00:00','24.22.24.316','SHAE ZAHSY HANANIA','P','TK','B','UMUM','B',11,'420000','03016DD0DU1F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 19:51:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','EC228DF00BDADF','13DFBAA91INW0VP951D1'),
	(149,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',1,'420000','83A16BFSP43D','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','7C01C30AHFNEMDUCD43D'),
	(150,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',2,'420000','C999E8SHZ00A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','DFEF3FBDCM0XPWU6C678'),
	(151,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',3,'420000','C999E66RGA3D','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','B1F2E9C2J54INVZ5BC05'),
	(152,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',4,'420000','C999EOVJ9BDA','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','6776735ENVXX2PS85612'),
	(153,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',5,'420000','C999EYO6SKAE','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','AF0E50D9VKADZHHB6DEB'),
	(154,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',6,'420000','C999EH05A70B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','4B5CD6E3NGGTXW12FB0B'),
	(155,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',7,'420000','2ADD5G4EAI0C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','2C30D125UY44JJT50993'),
	(156,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',8,'420000','2ADD5GUUMO1A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','440AB42CK1NITHL0C011'),
	(157,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',9,'420000','2ADD5C7Z9984','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','A9CE1859BI8EFWU23D3B'),
	(158,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',10,'420000','2ADD5LYY9LA5','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','A0965F01PVS38YH18793'),
	(159,'2025-07-21 00:00:00','24.22.24.308','MAYA SYIFA NUR&amp;#039;AINI','P','TK','B','UMUM','B',11,'420000','08D302GJZZ26','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','disc 1 bln','2025-07-24 19:54:14','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','4C89A91C2267FF','C66CA281UM0I751800C5'),
	(160,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',1,'420000','D3E68LP46X0C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','51811F14DN3CZRI9FFFC'),
	(161,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',2,'420000','D3E68YZ1OPD5','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','3747CB2DINA8JUB4EFC3'),
	(162,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',3,'420000','D3E68P5PWQ9E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','495958F1DOEALP171D91'),
	(163,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',4,'420000','D3E68SR7CMB2','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:55','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','3554463AJRIEUIJ0A9D3'),
	(164,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',5,'420000','4838588XZ134','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','926C1774LW8FQAQ20386'),
	(165,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',6,'420000','48385MZWATC6','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','1395FDECHQIWCCC09F0B'),
	(166,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',7,'420000','4838560X11DF','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','7C2765ADO5XMADW7F063'),
	(167,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',8,'420000','48385ORS3451','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:56','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','D381CADDOFYB9Y177A7B'),
	(168,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',9,'420000','05B2DPQ6EX6F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:57','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','592581BC2EUUBNWAF4C7'),
	(169,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',10,'420000','05B2DJWXQK71','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:57','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','B74187D9L2HTJPB16086'),
	(170,'2025-07-16 00:00:00','24.22.24.304','AFIYA NASYITA MUNANDAR','P','TK','B','UMUM','B',11,'420000','05B2DSW076A1','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:00:57','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FCB405D3B5314C','149ABD37LR6KFBTB17CC'),
	(171,'2025-07-21 00:00:00','24.22.24.315','SENANDUNG HUSNA GANTARI SETIAWAN','P','TK','B','UMUM','B',1,'420000','36025XAA9S7E','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:02:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','A270316FC71C56','B230A119QS1GOTAD6B1A'),
	(172,'2025-03-26 00:00:00','24.22.24.322','ELZAIDAN RAID ALHABSYI','L','TK','B','UMUM','C',1,'500000','420CE66P0C4F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:05:32','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','70C6A41FD4013E','386BFFFAZ5A958HAD9D1'),
	(173,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',1,'420000','A209AR8YTCC3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','CA06C49527AQ2XA19EA9'),
	(174,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',2,'420000','6986516LVJ7F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','4FC455FAX36QBG3A0B40'),
	(175,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',3,'420000','6986586XD50B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','A3318EA1MBURJ2QCB53E'),
	(176,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',4,'420000','69865HGJHM2B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','D859DB35UQKW3XI2D0F5'),
	(177,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',5,'420000','69865LZVRN34','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','4E561459WSO3F07EEF35'),
	(178,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',6,'420000','69865E2T0F3B','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','692040E3V87NALO99BC2'),
	(179,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',7,'420000','698659Z9JQ23','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:50','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','DF43914FHVIHKWTDC53E'),
	(180,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',8,'420000','8921DPXGK9A0','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','28F1E162TSY7B61678C2'),
	(181,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',9,'420000','8921DIXLMP6A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','246D93CAGPVGVURC59E1'),
	(182,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',10,'420000','8921DPCTH499','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','1C010396BUNY8SX2AE65'),
	(183,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','B',11,'420000','8921DJ7VL3AD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:06:51','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0CCB15BA96406B','2DFDA9E5E1SMARL36338'),
	(184,'2025-07-17 00:00:00','24.22.24.307','HASYA KHALISHA LASHIRA','P','TK','B','UMUM','C',1,'5500000','61B4E14VWFAD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:07:43','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C5EFFCBA960777','2FF72324VCJ4VPN820AB'),
	(185,'2025-07-18 00:00:00','24.22.24.311','RADEA WIRASENA ARSY','L','TK','B','UMUM','B',1,'420000','E046BCYS3ZFA','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:09:46','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FF88349684662F','FBF7110FT1E13Y10AB20'),
	(186,'2025-07-18 00:00:00','24.22.24.311','RADEA WIRASENA ARSY','L','TK','B','UMUM','B',2,'420000','E046BSLBTM70','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:09:46','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FF88349684662F','5E4EC846NXRP4OK17D7F'),
	(187,'2025-07-18 00:00:00','24.22.24.311','RADEA WIRASENA ARSY','L','TK','B','UMUM','B',3,'420000','E046BF0PGRAD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:09:46','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FF88349684662F','6A79C552BZY8SEPEF4B1'),
	(188,'2025-07-18 00:00:00','24.22.24.311','RADEA WIRASENA ARSY','L','TK','B','UMUM','B',4,'420000','F6586ZO17R26','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:09:47','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FF88349684662F','EE7AA7B4GBSAP8JB309A'),
	(189,'2025-03-17 00:00:00','24.22.24.330','RAZQA ZHAFRAN HAMDANI','L','TK','B','UMUM','C',1,'5500000','41BF2F88CFD8','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:12:14','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','2F03687886B430','93ABA21C3PNWWHJ15DEA'),
	(190,'2025-06-26 00:00:00','24.22.24.326','MIKHAIL JUNAULIAN AVANINDRA','L','TK','B','UMUM','C',1,'5500000','96E9DZ1VC478','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:14:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','59CB0F568CFAD6','DE0192E2AWE4T4QCF098'),
	(191,'2025-03-10 00:00:00','24.22.24.321','DINDA MARYAM NURGHAISANI','P','TK','B','UMUM','C',1,'5500000','3C200YOPEPD7','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:16:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','CA500E2D831BB5','6ADF566FU4A8DSTA518D'),
	(192,'2025-07-08 00:00:00','25.11.24.043','FADLAN','L','TK','B','UMUM','C',1,'3420000','0631AG5L7XD0','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:19:23','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7E7315290360CF','16841F3BPDVZ14Q4BC0B'),
	(193,'2025-07-14 00:00:00','25.11.24.032','GHAISANI ASMA KARUNIA','P','TK','B','UMUM','B',1,'420000','48F939MWKG4A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:20:40','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6FF9EECD106ADE','ACB9BFCBFTF5RZ38C815'),
	(194,'2024-11-25 00:00:00','25.11.24.023','MUHAMMAD NUR ALDIZAR SUYANTO','L','TK','B','UMUM','C',1,'2100000','C06A8NK3TA36','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:24:49','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D5744B123423B0','A100F907L29LEC722C59'),
	(195,'2025-05-19 00:00:00','25.11.24.023','MUHAMMAD NUR ALDIZAR SUYANTO','L','TK','B','UMUM','C',2,'2200000','99128D3JVL37','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:25:30','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F3F77F1234CF9F','BEFDD246ZNX1IND0BF61'),
	(196,'2025-06-06 00:00:00','25.11.24.034','MUHAMMAD EL HAQ JAYADIPA','L','TK','B','UMUM','C',1,'1200000','5D7E9W6T64F1','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:26:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F64178BC9C3409','373446DFDC7IMWZ94CC5'),
	(197,'2025-06-24 00:00:00','25.11.24.033','MUHAMMAD ARSYA FAUZAN','L','TK','B','UMUM','C',1,'500000','4B0B3MLMD359','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:27:36','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D213E11DDED690','69A51EB0KUW7YOS2EAA8'),
	(198,'2025-07-17 00:00:00','25.11.24.035','NADIRA HASNA&amp;#039;A CARISSA','P','TK','B','UMUM','B',1,'420000','3C56CE4WI6CD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:29:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','3F67970D93BE29','6C41A2D1HBRWUFP83159'),
	(199,'2025-07-16 00:00:00','25.11.24.036','NAYLA SYAFIRA NURFADHILLAH','P','TK','B','UMUM','B',1,'420000','1FCB4PY7IU05','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:30:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','56AFA2FAED9A42','7B5DF7D8QR96HPCE168F'),
	(200,'2025-06-19 00:00:00','25.11.24.003','AQILA SHAFA NADINE','P','KB','1','UMUM','C',2,'2050000','F0363G9TJG0F','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:41:02','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E740B82E5A80B6','8BD06A743FU3PUSB5AAC'),
	(201,'2025-07-14 00:00:00','25.11.24.001','ALZIO SYAFIQ','L','KB','1','UMUM','C',1,'1700000','FC068WXQD847','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:43:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','A44955815E5A82','EF36EBF5LO7LLYJ5BEDB'),
	(202,'2025-07-10 00:00:00','25.11.24.011','GAFFI ATHALLA DZIKRI','L','KB','1','UMUM','C',1,'2500000','8B10AEQTLNC7','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 20:48:12','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','97027262271793','0D5EDD7668CCRES7E5A2'),
	(203,'2025-05-19 00:00:00','25.11.24.008','MALAYKA NUR ADEEVA ABDURRAHMAN','P','KB','1','UMUM','C',1,'4800000','EC743DP85R3D','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 21:04:28','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5049E5653C4486','FAD459D8F1EDIOB58DFF'),
	(204,'2025-03-10 00:00:00','25.11.24.038','RAKANA MAHESWARI BIA','L','KB','1','UMUM','C',1,'5650000','33E1FSXUNP1D','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 21:10:59','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F9DEC5541105B0','1D4BD75CWLLATKMC3FF4'),
	(205,'2025-06-01 00:00:00','25.11.24.009','RAYYAN ALTAIR PRATAMA','L','KB','1','UMUM','C',1,'2200000','D66BFXPMWO06','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-24 21:12:13','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','6D3086C5E92790','554B0FCEP4TXY7IF3DA5'),
	(206,'2025-06-10 00:00:00','25.11.24.012','ABYAN ALIF FIRDAUS','L','TK','A','UMUM','C',1,'1200000','C8F9CX6NBG8C','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:14:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','19F61E6BC73B50','81273B05FFEGLB67A027'),
	(207,'2025-07-15 00:00:00','25.11.24.012','ABYAN ALIF FIRDAUS','L','TK','A','UMUM','C',2,'4800000','5F56D5PMM4A4','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:14:43','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','944BCF6BC7778D','8F3744A5FMKEUPA95FB7'),
	(208,'2025-07-09 00:00:00','25.11.24.013','ANDINY LAQUITTA PUTRIWIBOWO','P','TK','A','UMUM','C',1,'5800000','9E5E5R5US8B9','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:16:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','328E90C13E22A2','815E20D5MAVKJW4DDCE5'),
	(209,'2025-06-08 00:00:00','25.11.24.014','DARREN ACHAZIA RINALDI','L','TK','A','UMUM','C',1,'1000000','9FDC3S83SX4A','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:18:38','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','D69B9905217A8D','507BF5F687TTSDZ6134B'),
	(210,'2025-07-14 00:00:00','25.11.24.016','EL FATIH ATHARIZ PRATAMA','L','TK','A','UMUM','C',2,'1500000','A1AC6ELHXMEB','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:20:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','C19632E599D460','90784741M5D1H2M02ECE'),
	(211,'2025-06-24 00:00:00','25.11.24.017','FATHIR SHIDQI DHIAULHAQ','L','TK','A','UMUM','C',1,'1000000','EF4C2TII59E1','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:21:53','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','23FC174BACD536','BE97F9ACV82PZCQFC9AE'),
	(212,'2025-07-07 00:00:00','25.11.24.018','HAFIZH ZHAFRAN RAMDHANI','L','TK','A','UMUM','C',1,'1000000','15DC2FSXWSE3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 06:23:37','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','574B7300C30A2E','BE17BDE5JD6BSQ8E7BD7'),
	(213,'2025-06-10 00:00:00','25.11.24.021','KANAYAA MAULIDYA SUDARMAN ','P','TK','A','UMUM','C',1,'1200000','030A0SKFF671','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:05:00','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','FB32849BF7B078','2BFB556C1UNKHFXA5BF5'),
	(214,'2025-07-23 00:00:00','25.11.24.021','KANAYAA MAULIDYA SUDARMAN ','P','TK','A','UMUM','C',2,'4550000','782C98PD8J71','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:05:52','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','ED39A89BF7E93B','27D0C7C9B2T78X73331B'),
	(215,'2025-06-26 00:00:00','25.11.24.040','KENZIE ADHIYOPA RAIN','L','TK','A','UMUM','C',1,'500000','8B7FAAPKMFFD','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:08:27','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','60B04FA411BCE0','CC2FFA93B86JMO1ABD81'),
	(216,'2025-07-24 00:00:00','25.11.24.022','KHAIRIN NISAK HANAFIAH','P','TK','A','UMUM','C',2,'1100000','8572CRAPAZEA','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:09:39','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','E85AF0EA1AFE67','335D9E27FD2MPWC5AA16'),
	(217,'2025-06-30 00:00:00','25.11.24.041','MUHAMMAD EILSHAN NUGRAHA','L','TK','A','UMUM','C',1,'500000','72B4BIFDA025','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:10:39','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','71574526DCB8C4','E8BFCF69OQTQQDM04EC0'),
	(218,'2025-06-10 00:00:00','25.11.24.025','MUHAMMAD RAYYANDRA ZULFIKAR AL FATIH','L','TK','A','UMUM','C',1,'1200000','8F113Y6SEV37','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:12:07','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','F12BF3D7B0CDE5','2E822D25CVSS5KB3E721'),
	(219,'2025-07-12 00:00:00','25.11.24.026','MUHAMMAD ZEESHAN PERBAWA','L','TK','A','UMUM','C',1,'1000000','0736EYAC1SC5','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:13:03','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','7DBD566BDDE563','87BB7D89PDRHO6Q373D3'),
	(220,'2025-06-27 00:00:00','24.11.23.277','VELICA KIERAN SLAMET GHUMAISHA','P','TK','A','UMUM','C',5,'1500000','FD653X6ONMA9','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:16:20','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','CE9C81FF9AC444','0B66E35CAYH85PDC8E01'),
	(221,'2025-07-07 00:00:00','24.11.24.302','ZARA ARRAWFA NAYANIKA','P','TK','A','UMUM','C',1,'5500000','ED3F74MAN678','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:17:09','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','BFA3F7320B73D3','F72166DB46CP3SEEC4B1'),
	(222,'2025-07-14 00:00:00','24.22.24.319','AISHA RAIHANA HERYANTO','P','TK','B','UMUM','C',1,'1000000','90F466A4CVC3','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:28:25','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','338EBA3BB63C28','9FE6FAEDJ6ZFYHWD1E1F'),
	(223,'2025-07-14 00:00:00','24.22.24.306','HAFY RASYID ADSKHAN','L','TK','B','UMUM','C',1,'1000000','C4D84CHG5TF5','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:29:08','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','0C3E384614D125','24585BB3JFKQEWGF7732'),
	(224,'2025-07-07 00:00:00','24.22.24.313','RYUGA DANEER ERLEN','L','TK','B','UMUM','C',1,'2050000','8D36EEP5JUDB','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:30:11','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','55010BB928C5E7','3979D0DASIXXMSCB8159'),
	(225,'2025-07-21 00:00:00','24.22.24.315','SENANDUNG HUSNA GANTARI SETIAWAN','P','TK','B','UMUM','C',2,'1500000','27566HCO1KEB','7b7bc2512ee1fedcd76bdc68926d4f7b','','','Bank','','2025-07-25 07:31:28','26.149.10.249','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0','5DB4096FC7150D','D37D33DA1828BIXD438F');

-- ------------------------------------------------ 

DROP TABLE IF EXISTS `tabungan_transaksi2526`;

CREATE TABLE IF NOT EXISTS `tabungan_transaksi2526` (
  `no` int(11) NOT NULL AUTO_INCREMENT,
  `tanggal` date NOT NULL,
  `nis` varchar(18) NOT NULL,
  `nama` varchar(100) NOT NULL,
  `jenis` varchar(2) NOT NULL,
  `jumlah` varchar(15) NOT NULL,
  `jurnal` varchar(1) NOT NULL,
  `catatan` text NOT NULL,
  `created_by` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `id` varchar(50) NOT NULL,
  PRIMARY KEY (`no`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



-- ------------------------------------------------ 

